import java_cup.runtime.*;
import java.util.*;

%%

// The next 3 lines are included so that we can use the generated scanner
// with java CUP (the Java parser generator)
%public
%unicode
%cup
// Turn on line counting
%line
%column

%class Lexer
%function next_token  

IF = "if"
ELSE = "else"
LPAREN = "("
RPAREN = ")"
LT = "<"
GT = ">"
EQ = "="
PRINT = "print"
WS = [ \n\r\t]+
NUM = [:digit:]+

//States
%state YYINITIAL

%%
<YYINITIAL> {
{IF}			{return new Symbol(sym.IF,yyline+1,yycolumn+1);}	
{ELSE}		{return new Symbol(sym.ELSE,yyline+1,yycolumn+1);}
{LPAREN}		{return new Symbol(sym.LPAREN,yyline+1,yycolumn+1);}
{RPAREN}		{return new Symbol(sym.RPAREN,yyline+1,yycolumn+1);}
{GT}			{return new Symbol(sym.GT,yyline+1,yycolumn+1);}
{LT}			{return new Symbol(sym.LT,yyline+1,yycolumn+1);}
{EQ}			{return new Symbol(sym.EQ,yyline+1,yycolumn+1);}
{PRINT}		{return new Symbol(sym.PRINT,yyline+1,yycolumn+1);}
{NUM}			{return new Symbol(sym.NUM,yyline+1,yycolumn+1,new Integer(yytext()));}
{WS}			{}
.			{System.out.println("Lexic error "+yytext());return new Symbol(sym.error,yyline+1,yycolumn+1,yytext());}
}




