import java_cup.runtime.Symbol;
%%
%cup
%% 
[a-zA-Z] { return new Symbol(sym.LITERAL,yytext()); }
"." { return new Symbol(sym.CONCAT); }
"*" { return new Symbol(sym.KLEENE); }
"|" { return new Symbol(sym.OR); }
[ \t]+ { }
[\n] { return new Symbol(sym.NL); }
"(" { return new Symbol(sym.LPAREN); }
")" { return new Symbol(sym.RPAREN); }
%eofval {return new Symbol(sym.EOF);}
. { System.err.println("Illegal character: "+yytext()); System.exit(0); }
