import java_cup.runtime.Symbol;
%%
%cup
%% 
[0-9]* { return new Symbol(sym.NUM,new Double(yytext())); }
"+" { return new Symbol(sym.SUM); }
"*" { return new Symbol(sym.MUL); }
"/" { return new Symbol(sym.DIV); }
"-" { return new Symbol(sym.MIN); }
[ \t]+ { }
[\n] { return new Symbol(sym.NL); }
"(" { return new Symbol(sym.LPAREN); }
")" { return new Symbol(sym.RPAREN); }
%eofval {return new Symbol(sym.EOF);}
. { System.err.println("Illegal character: "+yytext()); System.exit(0); }
