
set NUTR ordered;
set FOOD ordered;

param cost {FOOD} >= 0;
param f_min {FOOD} >= 0, default 0;
param f_max {j in FOOD} >= f_min[j], default 2;

param n_min {NUTR} >= 0, default 0;
param n_max {i in NUTR} >= n_min[i], default Infinity;

param amt {NUTR,FOOD} >= 0;

# --------------------------------------------------------

var Buy {j in FOOD} integer >= f_min[j], <= f_max[j];

# --------------------------------------------------------

minimize Total_Cost:  sum {j in FOOD} cost[j] * Buy[j];

minimize Nutr_Amt {i in NUTR}: sum {j in FOOD} amt[i,j] * Buy[j];

# --------------------------------------------------------

subject to Diet {i in NUTR}:
   n_min[i] <= sum {j in FOOD} amt[i,j] * Buy[j] <= n_max[i];

# --------------------------------------------------------

subject to McNuggetsSauces:

      Buy["Hot Mustard Sauce"] + Buy["Barbeque Sauce"] +
      Buy["Sweet 'N Sour Sauce"] + Buy["Honey"]

   <= 2 * Buy["Chicken McNuggets (6 pcs)"] +
      3 * Buy["Chicken McNuggets (9 pcs)"] +
      6 * Buy["Chicken McNuggets (20 pcs)"];

subject to SaladToppings:

      Buy["Croutons"] +
      Buy["Bacon Bits"]

   <= Buy["Chef Salad"] +
      Buy["Chunky Chicken Salad"] +
      Buy["Garden Salad"] +
      Buy["Side Salad"];

subject to SaladDressings:

      Buy["Bleu Cheese Dressing"] +
      Buy["Ranch Dressing"] +
      Buy["1000 Island Dressing"] +
      Buy["Lite Vinaigrette Dressing"] +
      Buy["French Rdcd Cal Dressing"]

   <= Buy["Chef Salad"] +
      Buy["Chunky Chicken Salad"] +
      Buy["Garden Salad"] +
      Buy["Side Salad"];

subject to OneDrinkPerMeal:

   3 = Buy["Vanilla Shake"] +
       Buy["Chocolate Shake"] +
       Buy["Strawberry Shake"] +
       Buy["1% Lowfat Milk"] +
       Buy["Orange Juice"] +
       Buy["Coca-Cola (small)"] +
       Buy["Coca-Cola (medium)"] +
       Buy["Coca-Cola (large)"] +
       Buy["Diet Coke (small)"] +
       Buy["Diet Coke (medium)"] +
       Buy["Diet Coke (large)"] +
       Buy["Sprite (small)"] +
       Buy["Sprite (medium)"] +
       Buy["Sprite (large)"] +
       Buy["H-C Orange Drink (small)"] +
       Buy["H-C Orange Drink (medium)"] +
       Buy["H-C Orange Drink (large)"];

subject to FatCaloriesLimit:

            sum {j in FOOD} amt["CalFat",j] * Buy[j] 
   <= 0.3 * sum {j in FOOD} amt["Cal",j] * Buy[j];
