
////////////////////////////////////////////////////////////////////////////////
// Clase para definir un componente grafico que permite dibujar curvas dadas
// por arreglos de coordenadas

import java.awt.*;
import java.awt.event.*;

class Grafico extends Canvas {

    // variables de instancia
    private double [] x,y;  // coordenadas de los puntos de la curva
    private double xmin,xmax,ymin,ymax;  // area del espacio por dibujar
    static final int m = 20;  // el margen a los lados

    // "constructor"
    public void grafica( double[] x, double[] y,
			 double xmin, double xmax, double ymin, double ymax ) {
	this.x = (double[]) x.clone(); this.y = (double[]) y.clone();
	this.xmin = xmin; this.xmax = xmax; this.ymin = ymin; this.ymax = ymax;
	repaint();
    }

    // metodo para agrandar o reducir el area visible
    public void zoom(double f) {
	double nxmin, nxmax, nymin, nymax;
	nxmin = ((xmax+xmin)-f*(xmax-xmin))/2;
	nxmax = ((xmax+xmin)+f*(xmax-xmin))/2;
	nymin = ((ymax+ymin)-f*(ymax-ymin))/2;
	nymax = ((ymax+ymin)+f*(ymax-ymin))/2;
	xmin = nxmin; xmax = nxmax; ymin = nymin; ymax = nymax;
	repaint();
    }

    // metodo paint que se debe redefinir en funcion del comportamiento
    // especifico deseado para este tipo particular de canvas
    public void paint(Graphics g) {
	Dimension d = getSize();
	g.drawRect(m,m,d.width-2*m,d.height-2*m);
	g.clipRect(m,m,d.width-2*m,d.height-2*m);  // para que no dibuje fuera
	if (x == null || y == null || x.length != y.length) return;
	int cx1 = (int) Math.round((d.width-2*m)*(x[0]-xmin)/(xmax-xmin));
	int cy1 = (int) Math.round((d.height-2*m)*(y[0]-ymin)/(ymax-ymin));
	for (int i = 1; i < x.length; i++) {
	    int cx2 = (int) Math.round((d.width-2*m)*(x[i]-xmin)/(xmax-xmin));
	    int cy2 = (int) Math.round((d.height-2*m)*(y[i]-ymin)/(ymax-ymin));
	    g.drawLine(cx1+m,d.height-cy1-m,cx2+m,d.height-cy2-m);
	    cx1 = cx2; cy1 = cy2;
	}
    }
}


////////////////////////////////////////////////////////////////////////////////
// clase para crear interfaces de graficos de funciones

class Graficador extends Frame implements WindowListener, ActionListener {

    // componentes de la interfaz
    private Grafico G = new Grafico();  // el "canvas"
    private Button 
	ZoomIn = new Button("Zoom +"),
	ZoomOut = new Button("Zoom -");

    // constructor
    public Graficador() {
	//  disposicion de los componentes graficos en la ventana
	Panel P = new Panel();
	P.add(ZoomIn); P.add(ZoomOut);
	G.setSize(400,300);
	setLayout(new BorderLayout());
	add("North",P);
	add("Center",G);

	//  manejo de acciones de ventana y botones
	this.addWindowListener(this);
	ZoomIn.addActionListener(this);
	ZoomOut.addActionListener(this);

	pack();
	setVisible(true); // idem a show()
    }

    // metodo para graficar un curva definida por arreglos de coordenadas
    public void grafica( double[] x, double[] y,
			 double xmin, double xmax, double ymin, double ymax ) {
	G.grafica(x,y,xmin,xmax,ymin,ymax);
    }

    // metodos redefinidos para implementar WindowListener
    public void windowClosing(WindowEvent e) {System.exit(0);}
    public void windowClosed(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}

    // metodos redefinidos para implementar ActionListener
    public void actionPerformed(ActionEvent e) {
	Button B = (Button) e.getSource();
	if (B == ZoomIn) G.zoom(2.0/3.0);
	else if (B == ZoomOut) G.zoom(1.5);
    }
}

////////////////////////////////////////////////////////////////////////////////
// programa para probar el Dibujador
class UsaGraficador {
    public static void main(String[] args) {
	Graficador G = new Graficador();
	final int N = 100;
	double[] x = new double[N], y = new double[N];
	for (int i = 0; i < N; i++) {
	    x[i] = Math.cos(i*20.0/N); y[i] = Math.sin(i*20.0/N);
	    x[i] = x[i]*i/N; y[i] = y[i]*i/N;
	}
	G.grafica(x,y,-1,1,-1,1);
    }
}

//////////////////////////////////////////////////////////////////////////////

abstract class Pieza{

    protected int fila, col;
    protected String name;

    public Pieza(int x, int y, String s){
	fila = x; col = y; name = s;
    }

    abstract public boolean amenaza(int x, int y);
    public int getFila(){return fila;}
    public int getCol(){return col;}
}

class Torre extends Pieza{

    public Torre(int x, int y){
	// llamamos al constructor del Padre, TIENE que ser la primera instruccion del constructor!!
	super(x,y,"torre");
    }

    public boolean amenaza(int x, int y){
	if( (x == fila || y == col) && !(x != fila && y != col) )
	    return true;
	return false;
    }
}

class Caballo extends Pieza{

    public Caballo(int x, int y){
	super(x,y,"caballo");
    }

    public boolean amenaza(int x, int y){
	if( (Math.abs(x-fila) == 1 && Math.abs(y-col)==2) ||
	    (Math.abs(x-fila) == 2 && Math.abs(y-col)==1))
	    return true;
	return false;
    }
}

class Prueba{
    static public void main(String[] args){
	Pieza t = new Torre(2,2);
	System.out.println("Torre amenaza a (4,4) :"+t.amenaza(4,4)); //false
	System.out.println("Torre amenaza a (2,4) :"+t.amenaza(2,4)); //true
	Pieza c = new Caballo(4,3);
	System.out.println("Caballo amenaza a (6,5) :"+c.amenaza(6,5)); //false
	System.out.println("Caballo amenaza a (6,4) :"+c.amenaza(6,4)); //true
    }
}

///////////////////////////////////////////////////////////////////////////////

class P3{

    static public boolean semiMagica(double[][] m){
	int n = m.length, i,j;
	// guardamos la suma por filas y columnas
	// para eso creamos estos arreglos
	int[] filas = new int[n], cols = new int[n];
	
	for(i = 0; i < n; i++)
	    for(j = 0; j < n; j++){
		filas[i] += m[i][j];// sumamos la fila i-esima	    
		cols[i] += m[j][i];// sumamos la columna i-esima
	    }
      	
	for(i = 0; i < n; i++)
	    for(j = 0; j < n; j++)
		//comparamos la suma de la fila i-esima con todas las sumas por columnas
		if(filas[i] != cols[j]) // si alguna de estas comparaciones son distintas, significa que no es semimagica
		    return false;
	return true;
    }

    static public boolean magica(double[][] m){
	if(!semiMagica(m)) return false;
	int d1 = 0, d2 = 0, aux = 0;
	for(int k = 0; k < m.length; k++){
	    aux += m[0][k];  //sumo una fila para saber cuanto era la suma de la semimagica
	    d1 += m[k][k]; // suma la diagonal
	    d2 += m[k][m.length-k-1]; //suma la diagonal secundaria
	}
	return d1 == d2 && d1 == aux;  // diagonales iguales e iguales a la suma por fila y columa
    }

    static public void main(String[] s){
	double[][] m1 = {{16,3,2,13},{5,10,11,8},{9,6,7,12},{4,15,14,1}};
      	System.out.println("Semi-Magica?:" + semiMagica(m1));	
       	System.out.println("Magica?:" + magica(m1));
	
	double[][] m2 = {{0,1,-1},{-1,0,1},{1,-1,0}};
       	System.out.println("Semi-Magica?:" + semiMagica(m2));	
       	System.out.println("Magica?:" + magica(m2));

	double[][] m3 = {{-2,1,1},{1,-2,1},{1,1,-2}};
       	System.out.println("Semi-Magica?:" + semiMagica(m3));
       	System.out.println("Magica?:" + magica(m3));
    }
}
