import java.io.*;
import java.net.*;

public class Significados {

    public static void main(String[] args) throws Exception {
        String palabra = args[0];

        ConsultaSignificados[] consultas = new ConsultaSignificados[args.length - 1];
        for(int i = 1; i < args.length; i++) {
            consultas[i - 1] = new ConsultaSignificados(args[i], palabra);
		consultas[i-1].start();
        }

        for(int i = 0; i < consultas.length; i++) {
            consultas[i].join();

            System.out.println(consultas[i].getServidor() + ":" + consultas[i].getSignificado());
        }
    }
}

class ConsultaSignificados extends Thread {

	private String servidor;
        private String palabra;
        private String significado;

        public ConsultaSignificados(String servidor, String palabra) {
            this.servidor = servidor;
            this.palabra = palabra;
        }

        public void run(){
            try{
                Socket socket = new Socket(servidor, 1234);
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));

                out.println(palabra);
                significado = in.readLine();

                socket.close();
            }
            catch(Exception e) {		
            }
        }

        public String getServidor(){
            return servidor;
        }

        public String getSignificado() {
            if(significado.equals("null")) {
                return null;
            }
            return significado;
        }
}
