 import java.io.*;
 
 class P1 {
 
	static final int lEnter = System.getProperty("line.separator").length();
 
	// obtiene el grado del ingrediente identificado por cod
	static int obtenerGradoIngrediente(String cod) throws Exception {
		RandomAccessFile ingredientes = new RandomAccessFile("ingredientes.txt","r");
		// largo de cada lnea del archivo
		final long largoIngredientes = 4+20+4;
		// cantidad de lneas en el archivo
		long lineas = ingredientes.length()/(largoIngredientes+lEnter);
		// variables para la bsqueda binaria
		long mid;
		long inf = 0;
		long sup = lineas;
		// bsqueda binaria
		while(inf<=sup) {
			// voy a la mitad del archivo
			mid = (inf+sup)/2;
			ingredientes.seek( mid * (largoIngredientes + lEnter) );
			// leo la lnea
			String linea = ingredientes.readLine();
			// extraigo los campos
			String codigo = linea.substring(0,4);
			String nombre = linea.substring(4,24);
			int grado = Integer.parseInt(linea.substring(24).trim());
			if(codigo.compareTo(cod) < 0) inf = mid + 1;
            if(codigo.compareTo(cod) > 0) sup = mid - 1;
			if(codigo.compareTo(cod) == 0)
				return grado;
		}
		// si no lo encuentra retorno -1
		return -1;
	}
 
	// obtiene el grado alcohlico del trago identificado por cod
	static float obtenerGradoTrago(String cod) throws Exception {
		RandomAccessFile recetas = new RandomAccessFile("recetas.txt","r");
		// largo de cada lnea del archivo
		final long largoRecetas = 4+4+4;
		// cantidad de lneas en el archivo
		long lineas = recetas.length()/(largoRecetas+lEnter);
		// variables para la bsqueda binaria
		long mid;
		long inf = 0;
		long sup = lineas;
		// grado alcohlico del trago
		float grado = 0;
		// bsqueda binaria
		while(inf<=sup) {
			// voy a la mitad del archivo
			mid = (inf+sup)/2;
			recetas.seek( mid * (largoRecetas + lEnter) );
			// leo la lnea
			String linea = recetas.readLine();
			// extraigo los campos
			String cod_trago = linea.substring(0,4);
			String cod_ingrediente = linea.substring(4,8);
			int proporcion = Integer.parseInt(linea.substring(8,12).trim());
			// hago la comparacin por cdigo de trago
			if(cod_trago.compareTo(cod) < 0) inf = mid + 1;
            if(cod_trago.compareTo(cod) > 0) sup = mid - 1;
			if(cod_trago.compareTo(cod) == 0) {
				// sumo su grado
				grado += (float)obtenerGradoIngrediente(cod_ingrediente)*(float)proporcion/100.0;
				// veo hacia adelante y hacia atrs si se mantiene el cdigo del trago y sumo si es as
				for(long i=mid-1; i>=0; i--) {
					recetas.seek( mid * (largoRecetas + lEnter) );
					linea = recetas.readLine();
					cod_trago = linea.substring(0,4);
					if(cod_trago.equals(cod)) {
						cod_ingrediente = linea.substring(4,8);
						proporcion = Integer.parseInt(linea.substring(8,12).trim());
						grado += (float)obtenerGradoIngrediente(cod_ingrediente)*(float)proporcion/100.0;
					} else
						break;
				}
				for(long i=mid+1; i<=lineas; i++){
					recetas.seek( mid * (largoRecetas + lEnter) );
					linea = recetas.readLine();
					cod_trago = linea.substring(0,4);
					if(cod_trago.equals(cod)) {
						cod_ingrediente = linea.substring(4,8);
						proporcion = Integer.parseInt(linea.substring(8,12).trim());
						grado += (float)obtenerGradoIngrediente(cod_ingrediente)*(float)proporcion/100.0;
					} else
						break;
				}
				// salgo del ciclo
				break;
			}
		}
		return grado;
	}
	
	public static void main(String args[]) throws Exception {
		// itero sobre las lineas del  archivo de tragos
		BufferedReader tragos = new BufferedReader(new FileReader("tragos.txt"));
		// variables para el trago de menor grado alcohlico
		String nombreMenor = "";
		float menorGrado = 1000;
		String linea;
		while((linea=tragos.readLine())!=null) {
			String codigo = linea.substring(0,4);
			String nombre = linea.substring(4);
			float grado = obtenerGradoTrago(codigo);
			if(grado<menorGrado) {
				menorGrado = grado;
				nombreMenor = nombre;
			}
		}
		System.out.println("El trago de menor grado es " + nombreMenor);
	}
 
}

