
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Polaca {

    public static void main(String[] args)throws Exception{
        BufferedReader I = new BufferedReader(new InputStreamReader(System.in));
        Stack stack = new Stack();

        System.out.println("Ingrese la expresion en notacion polaca");
        String expresion = I.readLine();

        while(expresion.length() != 0){
            char c = expresion.charAt(0);

            if(esNumero(c)){
                stack.push(Integer.parseInt(c+""));
            }
            else if(esOperador(c)){
                double op2 = stack.pop();
                double op1 = stack.pop();
                stack.push(evaluar(op1, c, op2));
            }
            else{
                System.out.println("caracter invalido");
                System.exit(0);
            }
            expresion = expresion.substring(1);
        }
        System.out.println("El resultado de la expresion es: "+ stack.pop());
        I.close();
    }

    private static double evaluar(double op1, char c, double op2) {
        switch(c){
            case '*': return op1*op2;
            case '/': return op1/op2;
            case '+': return op1+op2;
            case '-': return op1-op2;
        }
        return 0;
    }

    private static boolean esOperador(char c) {
        String aux = ""+c;
        if(aux.equals("*") || aux.equals("\\") || aux.equals("+") ||aux.equals("-") ){
            return true;
        }
        return false;
    }

    private static boolean esNumero(char c) {
        switch(c){
            case '0': case '1': case '2': case '3': case '4':
            case '5': case '6': case '7': case '8': case '9':
                return true;
            default:
                return false;
        }
    }
}
