class P {
	public static void main(String[] args) {
		Polinomio p = new Polinomio();
		p.setCoeficiente(0, 10);
		p.setCoeficiente(1, 5);
		p.setCoeficiente(5, 7);
		p.setCoeficiente(5, 8);
		Polinomio q = new Polinomio();
		q.setCoeficiente(3, 8);
		q.setCoeficiente(6, 100);
		q.setCoeficiente(1, 4);
		q.setCoeficiente(0, 3);
		System.out.println(p);
		System.out.println(q);
		System.out.println(p.suma(q));
		System.out.println(p.producto(q));
	}
}

class Polinomio {
	protected Nodo primero;
	protected int grado;

	public Polinomio() {
		primero = null;
		grado = -1;
	}

	public Polinomio suma(Polinomio p) {
		int maxGrado = Math.max(p.grado, grado);
		Polinomio result = new Polinomio();
		for(int i = 0;i<=maxGrado;i++)
			result.setCoeficiente(i,getCoeficiente(i)+p.getCoeficiente(i));
		return result;
	}
	
	public Polinomio producto(Polinomio p) {
		int maxGrado = p.grado + grado;
		
		Polinomio result = new Polinomio();
		for(int i = 0;i<=maxGrado;i++) {
			double suma = 0;
			for(int j = 0;j<=i;j++)
				suma += this.getCoeficiente(j)*p.getCoeficiente(i-j);
			result.setCoeficiente(i, suma);
		}
		return result;
	}

	public void setCoeficiente(int exp, double coef) {
		if(grado>=exp) {
			int i = 0;
			Nodo aux = null;
			for(aux = primero; aux!=null && i<exp; aux = aux.sgte)
				i++;
			aux.valor = coef;
		}
		else {
			if(primero==null) {
				primero = new Nodo(0,null);
				grado = 0;
			}
				
			Nodo aux = primero;
			for(int i = 0;i<grado;i++)
				aux = aux.sgte;

			while(grado<exp) {
				aux.sgte = new Nodo(0,null);
				aux = aux.sgte;
				grado++;
			}
			aux.valor = coef;
		}
	}

	public double getCoeficiente(int exp) {
		if(exp>grado)
			return 0;
		else {
			int i = 0;
			Nodo aux = null;
			for(aux = primero; aux!=null && i<exp; aux = aux.sgte)
				i++;

			return aux.valor;
		}
	}

	public String toString() {
		if(grado<0)
			return "0";

		String s = "";
		for(int i = 0;i<=grado;i++)
			if(getCoeficiente(i)!=0)
				s += getCoeficiente(i)+"*x^"+i+(i<grado ? " + " : "");
		return s;
	}
}

class Nodo {
	double valor;
	Nodo sgte;

	public Nodo(double valor, Nodo sgte) {
		this.valor = valor;
		this.sgte = sgte;
	}
}