import java.io.*;

class Agenda {
	protected Nodo primero;
	
	public Agenda() {
		primero = null;
	}
	
	public void guardar(Persona p) {
		if(primero==null || p.compareTo(primero.valor)<=0)
			primero = new Nodo(p,primero);
		else {
			Nodo aux = null;
			for(aux = primero; aux.sgte!=null && p.compareTo(aux.sgte.valor)>0; aux = aux.sgte)
				;
			aux.sgte = new Nodo(p,aux.sgte);
		}
	}
	
	public Persona buscar(String nombre) {
		for(Nodo aux = primero; aux!=null; aux = aux.sgte)
			if(aux.valor.nombre.compareTo(nombre)==0)
				return aux.valor;
		return null;
	}
	
	public void borrar(String nombre) {
		if(primero==null)
			return;
		while(primero!=null && primero.valor.nombre.compareTo(nombre)==0)
			primero = primero.sgte;
			
		for(Nodo aux = primero; aux.sgte!=null; aux = aux.sgte)
			if(aux.sgte.valor.nombre.compareTo(nombre)==0) {
				while(aux.sgte!=null && aux.sgte.valor.nombre.compareTo(nombre)==0)
					aux.sgte = aux.sgte.sgte;
				return;
			}
	}
	
	public void println() {
		for(Nodo aux = primero; aux!=null; aux = aux.sgte)
			System.out.print(aux.valor.nombre+(aux.sgte!=null ? ", " : ""));
		System.out.println();
	}
}

/****************************************
 * Clases utiles para que el ejemplo funcione
 ****************************************/
class Persona implements Comparable {
	protected String nombre;
	
	public Persona(String s) {
		nombre = s;
	}
	
	public int compareTo(Object p) {
		if(p instanceof Persona) {
			return nombre.compareTo(((Persona)p).nombre);
		}
		return 1;
	}
}

class Nodo {
	Persona valor;
	Nodo sgte;
	
	public Nodo(Persona valor, Nodo sgte) {
		this.valor = valor;
		this.sgte = sgte;
	}
}

/********************
 * Problema ejemplo
 ********************/
class Problema2 {
	public static void main(String[] args) throws IOException {
		BufferedReader B = new BufferedReader(new InputStreamReader(System.in));
		Agenda a = new Agenda();
		while(true) {
			System.out.print("Opcion (1) Insertar, (2) Buscar, (3) Borrar: ");
			String op = B.readLine();
			if(op.equals("1")) {
				System.out.print("Nombre: ");
				String s = B.readLine();
				a.guardar(new Persona(s));
			}
			else if(op.equals("2")) {
				System.out.print("Nombre: ");
				String s = B.readLine();
				Persona p = a.buscar(s);
				System.out.println("Persona "+(p==null ? "no " : "")+"encontrada");
			}
			else if(op.equals("3")) {
				System.out.print("Nombre: ");
				String s = B.readLine();
				a.borrar(s);
			}
			else {
				return;
			}
			a.println();
		}
	}
}