import java.awt.*;

public class Laboratorio {

	Masa masas[];
        int nMasas;
	Resorte resortes[];
	int nResortes;

	public Laboratorio() {
		masas = new Masa[1000];
		resortes = new Resorte[1000];
		nMasas=0;
		nResortes=0;
	}

	public void dibuja(Graphics g) {
		g.setColor(Color.black);
		for (int i = 0; i < nMasas; i++) {
			Masa m = masas[i];
			g.fillOval((int) m.x - 3, (int) m.y - 3, 6, 6);
		}
		for (int i = 0; i < nResortes; i++) {
			Resorte r = resortes[i];
			g.drawLine((int) r.m1.x, (int) r.m1.y, (int) r.m2.x, (int) r.m2.y);
		}
	}

	void add(Masa m) {
		masas[nMasas]=m;
		nMasas++;
	}

	void add(Resorte r) {
		resortes[nResortes]=r;
		nResortes++;
	}

	void calculaNuevaPosicion() {
		for (int i = 0; i < nMasas; i++) {
			Masa m = masas[i];
			m.fx = 0;
			m.fy = 0;
		}
		for (int i = 0; i < nResortes; i++) {
			Resorte r = resortes[i];
			r.setFuerza();
		}

		for (int i = 0; i < nMasas; i++) {
			Masa m = masas[i];
			m.integra();
		}
	}


	public static void main(String args[]) {
		Laboratorio lab = new Laboratorio();
		Masa m1=new Masa(5,100,100);
		Masa m2=new Masa(5,400,200);
		Masa m3=new Masa(5,200,350);
		lab.add(m1);
		lab.add(m2);
		lab.add(m3);
		lab.add(new Resorte(m1, m2, 255));
		lab.add(new Resorte(m3, m2, 255));
		lab.add(new Resorte(m1, m3, 255));

		Frame f = new Frame();
		MiCanvas mic = new MiCanvas(lab);
		f.add(mic);
		f.pack();
		f.show();
		while (true) {
			try {
				Thread.sleep(20);
			} catch (Exception e) {
			}
			lab.calculaNuevaPosicion();
			mic.repaint();
		}
	}
}
