import java.awt.*;

public class Laboratorio {

	Masa masas[];
        int nMasas;
	Resorte resortes[];
	int nResortes;

	public Laboratorio() {
		masas = new Masa[1000];
		resortes = new Resorte[1000];
		nMasas=0;
		nResortes=0;
	}

	public void dibuja(Graphics g) {
              g.setColor(Color.black);
                for (int i = 0; i < nMasas; i++) {
                        Masa m = masas[i];
                        g.fillOval((int) m.x - 3, (int) m.y - 3, 6, 6);
                }
                for (int i = 0; i < nResortes; i++) {
                        Resorte r = resortes[i];
                        if (r.fuerza>0)
                                g.setColor(new Color(Math.min(255, Math.abs((int) r.fuerza)), 0, 0));
                        else
                                g.setColor(new Color(0,0,Math.min(255, Math.abs((int) r.fuerza))));
                        g.drawLine((int) r.m1.x, (int) r.m1.y, (int) r.m2.x, (int) r.m2.y);
                }
	}

	void add(Masa m) {
		masas[nMasas]=m;
		nMasas++;
	}

	void add(Resorte r) {
		resortes[nResortes]=r;
		nResortes++;
	}

	void calculaNuevaPosicion() {
		for (int i = 0; i < nMasas; i++) {
			Masa m = masas[i];
			m.fx = 0;
			m.fy = 0;
		}
		for (int i = 0; i < nResortes; i++) {
			Resorte r = resortes[i];
			r.setFuerza();
		}

		for (int i = 0; i < nMasas; i++) {
			Masa m = masas[i];
			m.integra();
		}
	}


	public static void main(String args[]) {
		Laboratorio lab = new Laboratorio();

                Masa m[] = new Masa[20];
                for (int i = 0; i < 20; i++) {
                        m[i] = new Masa(5, 10 + (i % 10) * 30, 100 + (i / 10) * 30);
                        lab.add(m[i]);
                }
                for (int i = 0; i < 9; i++) {
                        Masa m1 = m[i];
                        Masa m2 = m[i + 1];
                        Masa m4 = m[i + 10];
                        Masa m3 = m[i + 11];
                        lab.add(new Resorte(m1, m2, 255));
                        lab.add(new Resorte(m2, m3, 255));
                        lab.add(new Resorte(m3, m4, 255));
                        lab.add(new Resorte(m3, m1, 255));
                        lab.add(new Resorte(m2, m4, 255));
                }

		m[0].setFijo();
		m[10].setFijo();
		Masa mas=new Masa(5,0,0);
                lab.add(new Resorte(mas,m[9],255));

		Frame f = new Frame();
		MiCanvas mic = new MiCanvas(lab);
		f.add(mic);
		f.pack();
		f.show();
		int p=0;
		while (true) {
			p++;
			if (p==100) {
				m[0].fijo=false;
				m[10].fijo=false;
			}
			try {
				Thread.sleep(20);
			} catch (Exception e) {
			}
			lab.calculaNuevaPosicion();
			mic.repaint();
		}
	}
}
