class GrafoMain{
	public static void main(String[]args){
  		final int N=7;
  		Vertice[] v = new Vertice[N];
  		Grafo g=new Grafo();
  		for(int i=0; i<N; ++i)
    			g.agregarVertice(v[i]=new Vertice(""+(i+1)));
  		g.agregarArco(new Arco(v[0],v[1],2)); g.agregarArco(new Arco(v[0],v[2],5));
  		g.agregarArco(new Arco(v[0],v[3],3)); g.agregarArco(new Arco(v[1],v[2],6));
  		g.agregarArco(new Arco(v[2],v[3],4)); g.agregarArco(new Arco(v[2],v[4],1));
  		g.agregarArco(new Arco(v[4],v[5],4)); g.agregarArco(new Arco(v[4],v[6],3));
  		g.agregarArco(new Arco(v[5],v[6],2));
  		System.out.println("Arcos del Grafico Original"); mostrarGrafo(g);
  		Grafo arbol=Prim(g);
  		System.out.println("Arcos del Arbol Cobertor Minimo"); mostrarGrafo(arbol);
	}
	static public void mostrarGrafo(Grafo x){
  		for(int i=0; i<x.arcos(); ++i)
    		System.out.println( x.arco(i).toString() );
	}
	static public Grafo Prim(Grafo x){
  		Grafo g=new Grafo(x);
  		Grafo arbol=new Grafo();
  		Conexos c=new Conexos(); for(int i=0; i<g.vertices(); ++i) c.agregar(new Set(g.vertice(i)));
 
		Arco e=g.menorArco();
		Vertice v=e.v1, w=e.v2;
		arbol.agregarVertice(v); arbol.agregarVertice(w);
		arbol.agregarArco(e);
		g.borrarArco(e);
		c.union(c.find(v),c.find(w)); c.mostrar();

		while ( g.vertices()!=arbol.vertices() ){
			e=menorConV(g,arbol);  
                        v=e.v1; w=e.v2;
                        arbol.agregarVertice(v); arbol.agregarVertice(w);
                        arbol.agregarArco(e);
                        g.borrarArco(e);
			c.union(c.find(v),c.find(w)); c.mostrar();
		}
		return arbol;
	}
	static private Arco menorConV(Grafo g, Grafo arbol){
		Arco e=g.menorArco();
		Vertice v=e.v1, w=e.v2;
		if( pertenece(arbol,v) )
			if( pertenece(arbol,w) ){
				g.borrarArco(e);
				Arco f=menorConV(g,arbol);
				return f;
			}
			else	return e;
		else if( pertenece(arbol,w) )	
			return e; 
		else{	g.borrarArco(e);
                        Arco f=menorConV(g,arbol);
                        g.agregarArco(e);
			return f;
		}			
	}
	static private boolean pertenece(Grafo arbol, Vertice v){
		Vertice u;
		for(int i=0;i<arbol.vertices();++i){
			u=arbol.vertice(i);	
			if(v.equals(u)) return true;
		}
		return false;
	}
}
