import java.util.*;

public class Grafo{
	protected Vector V=new Vector(), E=new Vector();
	public int vertices(){ return V.size(); }
	public int arcos(){ return E.size(); }
	public boolean agregarVertice(Vertice x){
		int i=V.indexOf(x); if(i>=0) return false;
  		V.addElement(x); return true;
	}
	public boolean agregarArco(Arco x){
  		int i=E.indexOf(x); if(i>=0) return false;
  		E.addElement(x); return true;
	}
	public boolean borrarArco(Arco x){
  		int i=E.indexOf(x); if(i<0) return false;
  		E.removeElementAt(i); return true;
	}
	public boolean borrarVertice(Vertice x){
  		int i=V.indexOf(x); if(i<0) return false;
  		V.removeElementAt(i);
  		//borrar arcos con vertice en x
  		for(int j=0; j<E.size(); ++j)
    			if(((Arco)E.elementAt(j)).v1.equals(x)  || ((Arco)E.elementAt(j)).v2.equals(x) )
      				E.removeElementAt(j);
  		return true;
	}
	public Vertice vertice(int i){
  		return i>=V.size() ? null : (Vertice)V.elementAt(i);
	}
	public Arco arco(int i){
  		return i>=E.size() ? null : (Arco)E.elementAt(i);
	}
	public Arco menorArco(){
  		Arco min=null;
  		for(int i=0; i<E.size(); ++i)
    			if( min==null || ((Arco)E.elementAt(i)).compareTo(min)<0 )
      				min=(Arco)E.elementAt(i);
  		return min;
	}
	public Grafo(){}
	public Grafo(Grafo x){
  		for(int i=0; i<x.V.size(); ++i) V.addElement(x.V.elementAt(i));
  		for(int i=0; i<x.E.size(); ++i) E.addElement(x.E.elementAt(i));
	}
}
