/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class ResourceException
extends CoreException {
    public ResourceException(int code, IPath path, String message, Throwable exception) {
        super(new ResourceStatus(code, path, message, exception));
    }

    public ResourceException(IStatus status) {
        super(status);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream output) {
        PrintStream printStream = output;
        synchronized (printStream) {
            IStatus status = this.getStatus();
            if (status.getException() != null) {
                String path = "()";
                if (status instanceof IResourceStatus) {
                    path = "(" + ((IResourceStatus)status).getPath() + ")";
                }
                output.print(String.valueOf(this.getClass().getName()) + path + "[" + status.getCode() + "]: ");
                status.getException().printStackTrace(output);
            } else {
                super.printStackTrace(output);
            }
        }
    }

    public void printStackTrace(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            IStatus status = this.getStatus();
            if (status.getException() != null) {
                String path = "()";
                if (status instanceof IResourceStatus) {
                    path = "(" + ((IResourceStatus)status).getPath() + ")";
                }
                output.print(String.valueOf(this.getClass().getName()) + path + "[" + status.getCode() + "]: ");
                status.getException().printStackTrace(output);
            } else {
                super.printStackTrace(output);
            }
        }
    }
}

