/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.EscapeProcessorResult;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.trace.Tracer;
import com.mysql.jdbc.util.LRUCache;
import java.sql.BatchUpdateException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class Statement
implements java.sql.Statement {
    protected static int statementCounter;
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected List batchedArgs;
    protected SingleByteCharsetConverter charConverter = null;
    protected String charEncoding = null;
    protected Connection connection = null;
    protected String currentCatalog = null;
    protected boolean doEscapeProcessing = true;
    protected ProfileEventSink eventSink = null;
    private int fetchSize = 0;
    protected boolean isClosed = false;
    protected long lastInsertId = -1L;
    protected int maxFieldSize = MysqlIO.getMaxBuf();
    protected int maxRows = -1;
    protected boolean maxRowsChanged = false;
    protected List openResults = new ArrayList();
    protected boolean pedantic = false;
    protected Throwable pointOfOrigin;
    protected boolean profileSQL = false;
    protected ResultSet results = null;
    protected int resultSetConcurrency = 0;
    protected LRUCache resultSetMetadataCache;
    protected int resultSetType = 0;
    protected int statementId;
    protected int timeout = 0;
    protected long updateCount = -1L;
    protected boolean useUsageAdvisor = false;
    protected SQLWarning warningChain = null;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;
    private static final JoinPoint.StaticPart ajc$tjp_41;
    private static final JoinPoint.StaticPart ajc$tjp_42;
    private static final JoinPoint.StaticPart ajc$tjp_43;
    private static final JoinPoint.StaticPart ajc$tjp_44;
    private static final JoinPoint.StaticPart ajc$tjp_45;
    private static final JoinPoint.StaticPart ajc$tjp_46;
    private static final JoinPoint.StaticPart ajc$tjp_47;
    private static final JoinPoint.StaticPart ajc$tjp_48;
    private static final JoinPoint.StaticPart ajc$tjp_49;
    private static final JoinPoint.StaticPart ajc$tjp_50;
    private static final JoinPoint.StaticPart ajc$tjp_51;
    private static final JoinPoint.StaticPart ajc$tjp_52;

    static {
        Factory factory = new Factory("Statement.java", Class.forName("com.mysql.jdbc.Statement"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-addBatch-com.mysql.jdbc.Statement-java.lang.String:-sql:-java.sql.SQLException:-void-"), 238);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-cancel-com.mysql.jdbc.Statement---java.sql.SQLException:-void-"), 258);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-enableStreamingResults-com.mysql.jdbc.Statement---java.sql.SQLException:-void-"), 407);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-execute-com.mysql.jdbc.Statement-java.lang.String:-sql:-java.sql.SQLException:-boolean-"), 426);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-execute-com.mysql.jdbc.Statement-java.lang.String:int:-sql:returnGeneratedKeys:-java.sql.SQLException:-boolean-"), 568);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-execute-com.mysql.jdbc.Statement-java.lang.String:[I:-sql:generatedKeyIndices:-java.sql.SQLException:-boolean-"), 595);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-execute-com.mysql.jdbc.Statement-java.lang.String:[Ljava.lang.String;:-sql:generatedKeyNames:-java.sql.SQLException:-boolean-"), 622);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-executeBatch-com.mysql.jdbc.Statement---java.sql.SQLException:-[I-"), 659);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-executeQuery-com.mysql.jdbc.Statement-java.lang.String:-sql:-java.sql.SQLException:-java.sql.ResultSet-"), 733);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-executeUpdate-com.mysql.jdbc.Statement-java.lang.String:-sql:-java.sql.SQLException:-int-"), 871);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-executeUpdate-com.mysql.jdbc.Statement-java.lang.String:int:-sql:returnGeneratedKeys:-java.sql.SQLException:-int-"), 967);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-executeUpdate-com.mysql.jdbc.Statement-java.lang.String:[I:-sql:generatedKeyIndices:-java.sql.SQLException:-int-"), 994);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-checkClosed-com.mysql.jdbc.Statement---java.sql.SQLException:-void-"), 269);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-executeUpdate-com.mysql.jdbc.Statement-java.lang.String:[Ljava.lang.String;:-sql:generatedKeyNames:-java.sql.SQLException:-int-"), 1021);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getCachedMetaData-com.mysql.jdbc.Statement-java.lang.String:-sql:--com.mysql.jdbc.Statement$CachedResultSetMetaData-"), 1066);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getConnection-com.mysql.jdbc.Statement---java.sql.SQLException:-java.sql.Connection-"), 1083);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFetchDirection-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1095);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getFetchSize-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1107);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getGeneratedKeys-com.mysql.jdbc.Statement---java.sql.SQLException:-java.sql.ResultSet-"), 1120);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("24-getGeneratedKeysInternal-com.mysql.jdbc.Statement---java.sql.SQLException:-java.sql.ResultSet-"), 1130);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getId-com.mysql.jdbc.Statement----int-"), 1167);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getLastInsertID-com.mysql.jdbc.Statement----long-"), 1184);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getLongUpdateCount-com.mysql.jdbc.Statement----long-"), 1200);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-checkForDml-com.mysql.jdbc.Statement-java.lang.String:char:-sql:firstStatementChar:-java.sql.SQLException:-void-"), 289);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getMaxFieldSize-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1223);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getMaxRows-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1237);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getMoreResults-com.mysql.jdbc.Statement---java.sql.SQLException:-boolean-"), 1254);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getMoreResults-com.mysql.jdbc.Statement-int:-current:-java.sql.SQLException:-boolean-"), 1262);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getQueryTimeout-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1331);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getRecordCountFromInfo-com.mysql.jdbc.Statement-java.lang.String:-serverInfo:--int-"), 1343);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getResultSet-com.mysql.jdbc.Statement---java.sql.SQLException:-java.sql.ResultSet-"), 1413);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getResultSetConcurrency-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1426);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getResultSetHoldability-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1433);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getResultSetType-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1445);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-checkNullOrEmptyQuery-com.mysql.jdbc.Statement-java.lang.String:-sql:-java.sql.SQLException:-void-"), 314);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getUpdateCount-com.mysql.jdbc.Statement---java.sql.SQLException:-int-"), 1459);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getWarnings-com.mysql.jdbc.Statement---java.sql.SQLException:-java.sql.SQLWarning-"), 1500);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-initializeResultsMetadataFromCache-com.mysql.jdbc.Statement-java.lang.String:com.mysql.jdbc.Statement$CachedResultSetMetaData:com.mysql.jdbc.ResultSet:-sql:cachedMetaData:resultSet:-java.sql.SQLException:-void-"), 1533);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-realClose-com.mysql.jdbc.Statement-boolean:-calledExplicitly:-java.sql.SQLException:-void-"), 1576);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setCursorName-com.mysql.jdbc.Statement-java.lang.String:-name:-java.sql.SQLException:-void-"), 1642);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-setEscapeProcessing-com.mysql.jdbc.Statement-boolean:-enable:-java.sql.SQLException:-void-"), 1656);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setFetchDirection-com.mysql.jdbc.Statement-int:-direction:-java.sql.SQLException:-void-"), 1673);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-setFetchSize-com.mysql.jdbc.Statement-int:-rows:-java.sql.SQLException:-void-"), 1700);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-setMaxFieldSize-com.mysql.jdbc.Statement-int:-max:-java.sql.SQLException:-void-"), 1720);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-setMaxRows-com.mysql.jdbc.Statement-int:-max:-java.sql.SQLException:-void-"), 1749);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-clearBatch-com.mysql.jdbc.Statement---java.sql.SQLException:-void-"), 334);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setQueryTimeout-com.mysql.jdbc.Statement-int:-seconds:-java.sql.SQLException:-void-"), 1786);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20-setResultSetConcurrency-com.mysql.jdbc.Statement-int:-concurrencyFlag:--void-"), 1801);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20-setResultSetType-com.mysql.jdbc.Statement-int:-typeFlag:--void-"), 1811);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-clearWarnings-com.mysql.jdbc.Statement---java.sql.SQLException:-void-"), 347);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-close-com.mysql.jdbc.Statement---java.sql.SQLException:-void-"), 366);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-closeAllOpenResults-com.mysql.jdbc.Statement----void-"), 373);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-createStreamingResultSet-com.mysql.jdbc.Statement----boolean-"), 396);
        statementCounter = 1;
    }

    public Statement(Connection c, String catalog) throws SQLException {
        int maxRowsConn;
        boolean profiling;
        if (c == null || c.isClosed()) {
            throw new SQLException(Messages.getString("Statement.0"), "08003");
        }
        this.connection = c;
        this.currentCatalog = catalog;
        this.pedantic = this.connection.getPedantic();
        if (!this.connection.getDontTrackOpenResources()) {
            this.connection.registerStatement(this);
        }
        if (this.connection != null) {
            this.maxFieldSize = this.connection.getMaxAllowedPacket();
        }
        if (this.connection.getUseUnicode()) {
            this.charEncoding = this.connection.getEncoding();
            this.charConverter = this.connection.getCharsetConverter(this.charEncoding);
        }
        boolean bl = profiling = this.connection.getProfileSql() || this.connection.getUseUsageAdvisor();
        if (this.connection.getAutoGenerateTestcaseScript() || profiling) {
            this.statementId = statementCounter++;
        }
        if (profiling) {
            this.pointOfOrigin = new Throwable();
            this.profileSQL = this.connection.getProfileSql();
            this.useUsageAdvisor = this.connection.getUseUsageAdvisor();
            this.eventSink = ProfileEventSink.getInstance(this.connection);
        }
        if ((maxRowsConn = this.connection.getMaxRows()) != -1) {
            this.setMaxRows(maxRowsConn);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addBatch(String string) throws SQLException {
        void sql;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public void cancel() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    protected void checkClosed() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.isClosed) {
            throw new SQLException(Messages.getString("Statement.49"), "08003");
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    protected void checkForDml(String string, char c) throws SQLException {
        void sql;
        void firstStatementChar;
        String string2 = string;
        char c2 = c;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2, (Object)Conversions.charObject((char)c2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if ((firstStatementChar == 73 || firstStatementChar == 85 || firstStatementChar == 68 || firstStatementChar == 65 || firstStatementChar == 67) && (StringUtils.startsWithIgnoreCaseAndWs((String)sql, "INSERT") || StringUtils.startsWithIgnoreCaseAndWs((String)sql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs((String)sql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs((String)sql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs((String)sql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs((String)sql, "ALTER"))) {
            throw new SQLException(Messages.getString("Statement.57"), "S1009");
        }
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    protected void checkNullOrEmptyQuery(String string) throws SQLException {
        void sql;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (sql == null) {
            throw new SQLException(Messages.getString("Statement.59"), "S1009");
        }
        if (sql.length() == 0) {
            throw new SQLException(Messages.getString("Statement.61"), "S1009");
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public synchronized void clearBatch() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public synchronized void clearWarnings() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.warningChain = null;
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public synchronized void close() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.realClose(true);
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    protected void closeAllOpenResults() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.openResults != null) {
            Iterator iter = this.openResults.iterator();
            while (iter.hasNext()) {
                ResultSet element = (ResultSet)iter.next();
                try {
                    element.realClose(false);
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
            }
            this.openResults.clear();
        }
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    protected boolean createStreamingResultSet() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.fetchSize == Integer.MIN_VALUE;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public void enableStreamingResults() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.setFetchSize(Integer.MIN_VALUE);
        this.setResultSetType(1003);
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public synchronized boolean execute(String string) throws SQLException {
        String sql;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        char firstNonWsChar = StringUtils.firstNonWsCharUc(sql);
        boolean isSelect = true;
        if (firstNonWsChar != 'S') {
            isSelect = false;
            if (this.connection.isReadOnly()) {
                throw new SQLException(String.valueOf(Messages.getString("Statement.27")) + Messages.getString("Statement.28"), "S1009");
            }
        }
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn());
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        if (this.results != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        CachedResultSetMetaData cachedMetaData = null;
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.getCacheResultSetMetadata()) {
                cachedMetaData = this.getCachedMetaData(sql);
            }
            if (this.connection.useMaxRows()) {
                int rowLimit = -1;
                if (isSelect) {
                    if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                        rowLimit = this.maxRows;
                    } else if (this.maxRows <= 0) {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    } else {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    }
                } else {
                    this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                }
                rs = this.connection.execSQL(this, sql, rowLimit, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), isSelect, this.currentCatalog, cachedMetaData == null);
            } else {
                rs = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), isSelect, this.currentCatalog, cachedMetaData == null);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = rs.getUpdateID();
        if (rs != null) {
            this.results = rs;
            rs.setFirstCharOfQuery(firstNonWsChar);
            if (rs.reallyResult()) {
                if (cachedMetaData != null) {
                    this.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                } else if (this.connection.getCacheResultSetMetadata()) {
                    this.initializeResultsMetadataFromCache(sql, null, this.results);
                }
            }
        }
        boolean bl = rs != null && rs.reallyResult();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String string, int n) throws SQLException {
        boolean bl;
        JoinPoint joinPoint;
        block6: {
            void sql;
            void returnGeneratedKeys;
            String string2 = string;
            int n2 = n;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n2));
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (returnGeneratedKeys == true) {
                this.checkClosed();
                Object object = this.connection.getMutex();
                synchronized (object) {
                    boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                    this.connection.setReadInfoMsgEnabled(true);
                    try {
                        boolean bl2 = this.execute((String)sql);
                        Object var5_9 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var3_6
                        bl = bl2;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        throw throwable;
                    }
                }
            }
            bl = this.execute((String)sql);
        }
        boolean bl3 = bl;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl3), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl;
        JoinPoint joinPoint;
        block6: {
            void sql;
            void generatedKeyIndices;
            String string2 = string;
            int[] nArray2 = nArray;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2, (Object)nArray2);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (generatedKeyIndices != null && ((void)generatedKeyIndices).length > 0) {
                this.checkClosed();
                Object object = this.connection.getMutex();
                synchronized (object) {
                    boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                    this.connection.setReadInfoMsgEnabled(true);
                    try {
                        boolean bl2 = this.execute((String)sql);
                        Object var5_9 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var3_6
                        bl = bl2;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        throw throwable;
                    }
                }
            }
            bl = this.execute((String)sql);
        }
        boolean bl3 = bl;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl3), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl;
        JoinPoint joinPoint;
        block6: {
            void sql;
            void generatedKeyNames;
            String string2 = string;
            String[] stringArray2 = stringArray;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (generatedKeyNames != null && ((void)generatedKeyNames).length > 0) {
                this.checkClosed();
                Object object = this.connection.getMutex();
                synchronized (object) {
                    boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                    this.connection.setReadInfoMsgEnabled(true);
                    try {
                        boolean bl2 = this.execute((String)sql);
                        Object var5_9 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var3_6
                        bl = bl2;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        throw throwable;
                    }
                }
            }
            bl = this.execute((String)sql);
        }
        boolean bl3 = bl;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl3), joinPoint);
        return bl;
    }

    public synchronized int[] executeBatch() throws SQLException {
        int[] nArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.connection.isReadOnly()) {
            throw new SQLException(String.valueOf(Messages.getString("Statement.34")) + Messages.getString("Statement.35"), "S1009");
        }
        if (this.results != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        try {
            int[] updateCounts = null;
            if (this.batchedArgs != null) {
                int nbrCommands = this.batchedArgs.size();
                updateCounts = new int[nbrCommands];
                int i = 0;
                while (i < nbrCommands) {
                    updateCounts[i] = -3;
                    ++i;
                }
                Throwable sqlEx = null;
                int commandIndex = 0;
                commandIndex = 0;
                while (commandIndex < nbrCommands) {
                    try {
                        updateCounts[commandIndex] = this.executeUpdate((String)this.batchedArgs.get(commandIndex));
                    }
                    catch (SQLException ex) {
                        updateCounts[commandIndex] = -3;
                        if (this.connection.getContinueBatchOnError()) {
                            sqlEx = ex;
                        }
                        int[] newUpdateCounts = new int[commandIndex];
                        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                    }
                    ++commandIndex;
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        int[] nArray2 = nArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(nArray2, joinPoint);
        return nArray;
    }

    public synchronized java.sql.ResultSet executeQuery(String string) throws SQLException {
        String sql;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn());
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        char firstStatementChar = StringUtils.firstNonWsCharUc(sql);
        this.checkForDml(sql, firstStatementChar);
        if (this.results != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        CachedResultSetMetaData cachedMetaData = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.getCacheResultSetMetadata()) {
                cachedMetaData = this.getCachedMetaData(sql);
            }
            if (this.connection.useMaxRows()) {
                if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                    this.results = this.connection.execSQL(this, sql, this.maxRows, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog, cachedMetaData == null);
                } else {
                    if (this.maxRows <= 0) {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    } else {
                        this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
                    }
                    this.results = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog, cachedMetaData == null);
                    if (oldCatalog != null) {
                        this.connection.setCatalog(oldCatalog);
                    }
                }
            } else {
                this.results = this.connection.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, this.createStreamingResultSet(), true, this.currentCatalog, cachedMetaData == null);
            }
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.lastInsertId = this.results.getUpdateID();
        if (cachedMetaData != null) {
            this.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
        } else if (this.connection.getCacheResultSetMetadata()) {
            this.initializeResultsMetadataFromCache(sql, null, this.results);
        }
        ResultSet resultSet = this.results;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        String sql;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.checkNullOrEmptyQuery(sql);
        this.checkClosed();
        if (this.connection.isReadOnly()) {
            throw new SQLException(String.valueOf(Messages.getString("Statement.42")) + Messages.getString("Statement.43"), "S1009");
        }
        if (StringUtils.startsWithIgnoreCaseAndWs(sql, "select")) {
            throw new SQLException(Messages.getString("Statement.46"), "01S03");
        }
        char firstStatementChar = StringUtils.firstNonWsCharUc(sql);
        if (this.doEscapeProcessing) {
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn());
            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        if (this.results != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        ResultSet rs = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            String oldCatalog = null;
            if (!this.connection.getCatalog().equals(this.currentCatalog)) {
                oldCatalog = this.connection.getCatalog();
                this.connection.setCatalog(this.currentCatalog);
            }
            if (this.connection.useMaxRows()) {
                this.connection.execSQL(this, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.currentCatalog, true);
            }
            rs = this.connection.execSQL(this, sql, -1, null, 1003, 1007, false, false, this.currentCatalog, true);
            if (oldCatalog != null) {
                this.connection.setCatalog(oldCatalog);
            }
        }
        this.results = rs;
        rs.setFirstCharOfQuery(firstStatementChar);
        this.updateCount = rs.getUpdateCount();
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        int n = truncatedUpdateCount;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String string, int n) throws SQLException {
        int n2;
        JoinPoint joinPoint;
        block6: {
            void sql;
            void returnGeneratedKeys;
            String string2 = string;
            int n3 = n;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)string2, (Object)Conversions.intObject((int)n3));
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (returnGeneratedKeys == true) {
                this.checkClosed();
                Object object = this.connection.getMutex();
                synchronized (object) {
                    boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                    this.connection.setReadInfoMsgEnabled(true);
                    try {
                        int n4 = this.executeUpdate((String)sql);
                        Object var5_9 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var3_6
                        n2 = n4;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        throw throwable;
                    }
                }
            }
            n2 = this.executeUpdate((String)sql);
        }
        int n5 = n2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n5), joinPoint);
        return n2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        int n;
        JoinPoint joinPoint;
        block6: {
            void sql;
            void generatedKeyIndices;
            String string2 = string;
            int[] nArray2 = nArray;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)string2, (Object)nArray2);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (generatedKeyIndices != null && ((void)generatedKeyIndices).length > 0) {
                this.checkClosed();
                Object object = this.connection.getMutex();
                synchronized (object) {
                    boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                    this.connection.setReadInfoMsgEnabled(true);
                    try {
                        int n2 = this.executeUpdate((String)sql);
                        Object var5_9 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var3_6
                        n = n2;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        throw throwable;
                    }
                }
            }
            n = this.executeUpdate((String)sql);
        }
        int n3 = n;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n3), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        int n;
        JoinPoint joinPoint;
        block6: {
            void sql;
            void generatedKeyNames;
            String string2 = string;
            String[] stringArray2 = stringArray;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (generatedKeyNames != null && ((void)generatedKeyNames).length > 0) {
                this.checkClosed();
                Object object = this.connection.getMutex();
                synchronized (object) {
                    boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                    this.connection.setReadInfoMsgEnabled(true);
                    try {
                        int n2 = this.executeUpdate((String)sql);
                        Object var5_9 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var3_6
                        n = n2;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        this.connection.setReadInfoMsgEnabled(readInfoMsgState);
                        throw throwable;
                    }
                }
            }
            n = this.executeUpdate((String)sql);
        }
        int n3 = n;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n3), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    protected CachedResultSetMetaData getCachedMetaData(String string) {
        void sql;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        CachedResultSetMetaData cachedResultSetMetaData = this.resultSetMetadataCache != null ? (CachedResultSetMetaData)this.resultSetMetadataCache.get(sql) : null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(cachedResultSetMetaData, joinPoint);
        return cachedResultSetMetaData;
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Connection connection = this.connection;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(connection, joinPoint);
        return connection;
    }

    public int getFetchDirection() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = 1000;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return 1000;
    }

    public synchronized int getFetchSize() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.fetchSize;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public synchronized java.sql.ResultSet getGeneratedKeys() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        java.sql.ResultSet resultSet = this.getGeneratedKeysInternal();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    protected synchronized java.sql.ResultSet getGeneratedKeysInternal() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 17)};
        ArrayList<byte[][]> rowSet = new ArrayList<byte[][]>();
        long beginAt = this.getLastInsertID();
        int numKeys = this.getUpdateCount();
        String serverInfo = this.results.getServerInfo();
        if (numKeys > 0 && this.results.getFirstCharOfQuery() == 'R' && serverInfo != null && serverInfo.length() > 0) {
            numKeys = this.getRecordCountFromInfo(serverInfo);
        }
        if (beginAt > 0L && numKeys > 0) {
            int i = 0;
            while (i < numKeys) {
                byte[][] row = new byte[][]{Long.toString(beginAt++).getBytes()};
                rowSet.add(row);
                ++i;
            }
        }
        ResultSet resultSet = new ResultSet(this.currentCatalog, fields, new RowDataStatic(rowSet), this.connection, this);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    protected int getId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.statementId;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public synchronized long getLastInsertID() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l = this.lastInsertId;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    public synchronized long getLongUpdateCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l = this.results == null ? -1L : (this.results.reallyResult() ? -1L : this.updateCount);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.maxFieldSize;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public synchronized int getMaxRows() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.maxRows <= 0 ? 0 : this.maxRows;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public boolean getMoreResults() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.getMoreResults(1);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean getMoreResults(int n) throws SQLException {
        boolean bl;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.results == null) {
            bl = false;
        } else {
            void current;
            ResultSet nextResultSet = this.results.getNextResultSet();
            switch (current) {
                case 1: {
                    if (this.results == null) break;
                    this.results.close();
                    this.results.clearNextResult();
                    break;
                }
                case 3: {
                    if (this.results != null) {
                        this.results.close();
                        this.results.clearNextResult();
                    }
                    this.closeAllOpenResults();
                    break;
                }
                case 2: {
                    if (!this.connection.getDontTrackOpenResources()) {
                        this.openResults.add(this.results);
                    }
                    this.results.clearNextResult();
                    break;
                }
                default: {
                    throw new SQLException(Messages.getString("Statement.19"), "S1009");
                }
            }
            this.results = nextResultSet;
            if (this.results == null) {
                this.updateCount = -1L;
                this.lastInsertId = -1L;
            } else if (this.results.reallyResult()) {
                this.updateCount = -1L;
                this.lastInsertId = -1L;
            } else {
                this.updateCount = this.results.getUpdateCount();
                this.lastInsertId = this.results.getUpdateID();
            }
            bl = this.results != null && this.results.reallyResult();
        }
        boolean bl2 = bl;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    public int getQueryTimeout() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.timeout;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int getRecordCountFromInfo(String string) {
        void serverInfo;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer recordsBuf = new StringBuffer();
        int recordsCount = 0;
        int duplicatesCount = 0;
        char c = '\u0000';
        int length = serverInfo.length();
        int i = 0;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (Character.isDigit(c)) break;
            ++i;
        }
        recordsBuf.append(c);
        ++i;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (!Character.isDigit(c)) break;
            recordsBuf.append(c);
            ++i;
        }
        recordsCount = Integer.parseInt(recordsBuf.toString());
        StringBuffer duplicatesBuf = new StringBuffer();
        while (i < length) {
            c = serverInfo.charAt(i);
            if (Character.isDigit(c)) break;
            ++i;
        }
        duplicatesBuf.append(c);
        ++i;
        while (i < length) {
            c = serverInfo.charAt(i);
            if (!Character.isDigit(c)) break;
            duplicatesBuf.append(c);
            ++i;
        }
        duplicatesCount = Integer.parseInt(duplicatesBuf.toString());
        int n = recordsCount - duplicatesCount;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public synchronized java.sql.ResultSet getResultSet() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        java.sql.ResultSet resultSet = this.results != null && this.results.reallyResult() ? (java.sql.ResultSet)this.results : null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    public synchronized int getResultSetConcurrency() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.resultSetConcurrency;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public int getResultSetHoldability() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = 1;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return 1;
    }

    public synchronized int getResultSetType() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.resultSetType;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public synchronized int getUpdateCount() throws SQLException {
        int n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.results == null) {
            n = -1;
        } else if (this.results.reallyResult()) {
            n = -1;
        } else {
            int truncatedUpdateCount = 0;
            truncatedUpdateCount = this.results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.results.getUpdateCount();
            n = truncatedUpdateCount;
        }
        int n2 = n;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
        return n;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            SQLWarning pendingWarningsFromServer = SQLError.convertShowWarningsToSQLWarnings(this.connection);
            if (this.warningChain != null) {
                this.warningChain.setNextWarning(pendingWarningsFromServer);
            } else {
                this.warningChain = pendingWarningsFromServer;
            }
            sQLWarning = this.warningChain;
        } else {
            sQLWarning = this.warningChain;
        }
        SQLWarning sQLWarning2 = sQLWarning;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(sQLWarning2, joinPoint);
        return sQLWarning;
    }

    /*
     * WARNING - void declaration
     */
    protected void initializeResultsMetadataFromCache(String string, CachedResultSetMetaData cachedResultSetMetaData, ResultSet resultSet) throws SQLException {
        void resultSet2;
        String string2 = string;
        CachedResultSetMetaData cachedResultSetMetaData2 = cachedResultSetMetaData;
        ResultSet resultSet3 = resultSet;
        Object[] objectArray = new Object[]{string2, cachedResultSetMetaData2, resultSet3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        void var4_9 = resultSet2;
        synchronized (var4_9) {
            CachedResultSetMetaData cachedMetaData;
            if (cachedMetaData == null) {
                void sql;
                cachedMetaData = new CachedResultSetMetaData();
                cachedMetaData.fields = this.results.fields;
                resultSet2.buildIndexMapping();
                cachedMetaData.columnNameToIndex = resultSet2.columnNameToIndex;
                cachedMetaData.fullColumnNameToIndex = resultSet2.fullColumnNameToIndex;
                cachedMetaData.metadata = resultSet2.getMetaData();
                if (this.resultSetMetadataCache == null) {
                    this.resultSetMetadataCache = new LRUCache(this.connection.getMetadataCacheSize());
                }
                this.resultSetMetadataCache.put(sql, cachedMetaData);
            } else {
                resultSet2.fields = cachedMetaData.fields;
                resultSet2.columnNameToIndex = cachedMetaData.columnNameToIndex;
                resultSet2.fullColumnNameToIndex = cachedMetaData.fullColumnNameToIndex;
                resultSet2.hasBuiltIndexMapping = true;
            }
        }
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    protected void realClose(boolean bl) throws SQLException {
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (!this.isClosed) {
            void calledExplicitly;
            if (this.useUsageAdvisor && calledExplicitly == false) {
                String message = String.valueOf(Messages.getString("Statement.63")) + Messages.getString("Statement.64");
                this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.currentCatalog, this.connection.getId(), this.getId(), -1, System.currentTimeMillis(), 0, null, this.pointOfOrigin, message));
            }
            if (this.results != null && this.connection != null && !this.connection.getHoldResultsOpenOverStatementClose()) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {}
            }
            if (this.connection != null) {
                if (this.maxRowsChanged) {
                    this.connection.unsetMaxRows(this);
                }
                if (!this.connection.getDontTrackOpenResources()) {
                    this.connection.unregisterStatement(this);
                }
            }
            this.closeAllOpenResults();
            this.results = null;
            this.connection = null;
            this.warningChain = null;
            this.openResults = null;
            this.isClosed = true;
        }
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    public void setCursorName(String string) throws SQLException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        void enable;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.doEscapeProcessing = enable;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setFetchDirection(int n) throws SQLException {
        void direction;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new SQLException(Messages.getString("Statement.5"), "S1009");
            }
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setFetchSize(int n) throws SQLException {
        void rows;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.getMaxRows()) {
            throw new SQLException(Messages.getString("Statement.7"), "S1009");
        }
        this.fetchSize = rows;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setMaxFieldSize(int n) throws SQLException {
        int maxBuf;
        void max;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (max < 0) {
            throw new SQLException(Messages.getString("Statement.11"), "S1009");
        }
        int n3 = maxBuf = this.connection != null ? this.connection.getMaxAllowedPacket() : MysqlIO.getMaxBuf();
        if (max > maxBuf) {
            throw new SQLException(Messages.getString("Statement.13", new Object[]{new Long(maxBuf)}), "S1009");
        }
        this.maxFieldSize = max;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        int max;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (max > 50000000 || max < 0) {
            throw new SQLException(String.valueOf(Messages.getString("Statement.15")) + max + " > " + 50000000 + ".", "S1009");
        }
        if (max == 0) {
            max = -1;
        }
        this.maxRows = max;
        this.maxRowsChanged = true;
        if (this.maxRows == -1) {
            this.connection.unsetMaxRows(this);
            this.maxRowsChanged = false;
        } else {
            this.connection.maxRowsChanged(this);
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setQueryTimeout(int n) throws SQLException {
        void seconds;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (seconds < 0) {
            throw new SQLException(Messages.getString("Statement.21"), "S1009");
        }
        this.timeout = seconds;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setResultSetConcurrency(int n) {
        void concurrencyFlag;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.resultSetConcurrency = concurrencyFlag;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setResultSetType(int n) {
        void typeFlag;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.resultSetType = typeFlag;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    class CachedResultSetMetaData {
        Map columnNameToIndex = null;
        Field[] fields;
        Map fullColumnNameToIndex = null;
        ResultSetMetaData metadata;

        CachedResultSetMetaData() {
        }
    }
}

