/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.trace.Tracer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

final class MysqlDefs {
    static final int COM_BINLOG_DUMP = 18;
    static final int COM_CHANGE_USER = 17;
    static final int COM_CLOSE_STATEMENT = 25;
    static final int COM_CONNECT_OUT = 20;
    static final int COM_END = 28;
    static final int COM_EXECUTE = 23;
    static final int COM_LONG_DATA = 24;
    static final int COM_PREPARE = 22;
    static final int COM_REGISTER_SLAVE = 21;
    static final int COM_RESET_STMT = 26;
    static final int COM_SET_OPTION = 27;
    static final int COM_TABLE_DUMP = 19;
    static final int CONNECT = 11;
    static final int CREATE_DB = 5;
    static final int DEBUG = 13;
    static final int DELAYED_INSERT = 16;
    static final int DROP_DB = 6;
    static final int FIELD_LIST = 4;
    static final int FIELD_TYPE_BIT = 16;
    static final int FIELD_TYPE_BLOB = 252;
    static final int FIELD_TYPE_DATE = 10;
    static final int FIELD_TYPE_DATETIME = 12;
    static final int FIELD_TYPE_DECIMAL = 0;
    static final int FIELD_TYPE_DOUBLE = 5;
    static final int FIELD_TYPE_ENUM = 247;
    static final int FIELD_TYPE_FLOAT = 4;
    static final int FIELD_TYPE_GEOMETRY = 255;
    static final int FIELD_TYPE_INT24 = 9;
    static final int FIELD_TYPE_LONG = 3;
    static final int FIELD_TYPE_LONG_BLOB = 251;
    static final int FIELD_TYPE_LONGLONG = 8;
    static final int FIELD_TYPE_MEDIUM_BLOB = 250;
    static final int FIELD_TYPE_NEW_DECIMAL = 246;
    static final int FIELD_TYPE_NEWDATE = 14;
    static final int FIELD_TYPE_NULL = 6;
    static final int FIELD_TYPE_SET = 248;
    static final int FIELD_TYPE_SHORT = 2;
    static final int FIELD_TYPE_STRING = 254;
    static final int FIELD_TYPE_TIME = 11;
    static final int FIELD_TYPE_TIMESTAMP = 7;
    static final int FIELD_TYPE_TINY = 1;
    static final int FIELD_TYPE_TINY_BLOB = 249;
    static final int FIELD_TYPE_VAR_STRING = 253;
    static final int FIELD_TYPE_VARCHAR = 15;
    static final int FIELD_TYPE_YEAR = 13;
    static final int INIT_DB = 2;
    static final long LENGTH_BLOB = 65535L;
    static final long LENGTH_LONGBLOB = 0xFFFFFFFFL;
    static final long LENGTH_MEDIUMBLOB = 0xFFFFFFL;
    static final long LENGTH_TINYBLOB = 255L;
    static final int MAX_ROWS = 50000000;
    public static final int NO_CHARSET_INFO = -1;
    static final int PING = 14;
    static final int PROCESS_INFO = 10;
    static final int PROCESS_KILL = 12;
    static final int QUERY = 3;
    static final int QUIT = 1;
    static final int RELOAD = 7;
    static final int SHUTDOWN = 8;
    static final int SLEEP = 0;
    static final int STATISTICS = 9;
    static final int TIME = 15;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    MysqlDefs() {
    }

    static int mysqlToJavaType(int n) {
        int jdbcType;
        int mysqlType;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        switch (mysqlType) {
            case 0: 
            case 246: {
                jdbcType = 3;
                break;
            }
            case 1: {
                jdbcType = -6;
                break;
            }
            case 2: {
                jdbcType = 5;
                break;
            }
            case 3: {
                jdbcType = 4;
                break;
            }
            case 4: {
                jdbcType = 7;
                break;
            }
            case 5: {
                jdbcType = 8;
                break;
            }
            case 6: {
                jdbcType = 0;
                break;
            }
            case 7: {
                jdbcType = 93;
                break;
            }
            case 8: {
                jdbcType = -5;
                break;
            }
            case 9: {
                jdbcType = 4;
                break;
            }
            case 10: {
                jdbcType = 91;
                break;
            }
            case 11: {
                jdbcType = 92;
                break;
            }
            case 12: {
                jdbcType = 93;
                break;
            }
            case 13: {
                jdbcType = 91;
                break;
            }
            case 14: {
                jdbcType = 91;
                break;
            }
            case 247: {
                jdbcType = 1;
                break;
            }
            case 248: {
                jdbcType = 1;
                break;
            }
            case 249: {
                jdbcType = -3;
                break;
            }
            case 250: {
                jdbcType = -4;
                break;
            }
            case 251: {
                jdbcType = -4;
                break;
            }
            case 252: {
                jdbcType = -4;
                break;
            }
            case 15: 
            case 253: {
                jdbcType = 12;
                break;
            }
            case 254: {
                jdbcType = 1;
                break;
            }
            case 255: {
                jdbcType = -2;
                break;
            }
            case 16: {
                jdbcType = -7;
                break;
            }
            default: {
                jdbcType = 12;
            }
        }
        int n3 = jdbcType;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n3), joinPoint);
        return n3;
    }

    static int mysqlToJavaType(String string) {
        String mysqlType;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = mysqlType.equalsIgnoreCase("TINYINT") ? MysqlDefs.mysqlToJavaType(1) : (mysqlType.equalsIgnoreCase("SMALLINT") ? MysqlDefs.mysqlToJavaType(2) : (mysqlType.equalsIgnoreCase("MEDIUMINT") ? MysqlDefs.mysqlToJavaType(9) : (mysqlType.equalsIgnoreCase("INT") || mysqlType.equalsIgnoreCase("INTEGER") ? MysqlDefs.mysqlToJavaType(3) : (mysqlType.equalsIgnoreCase("BIGINT") ? MysqlDefs.mysqlToJavaType(8) : (mysqlType.equalsIgnoreCase("INT24") ? MysqlDefs.mysqlToJavaType(9) : (mysqlType.equalsIgnoreCase("REAL") ? MysqlDefs.mysqlToJavaType(5) : (mysqlType.equalsIgnoreCase("FLOAT") ? MysqlDefs.mysqlToJavaType(4) : (mysqlType.equalsIgnoreCase("DECIMAL") ? MysqlDefs.mysqlToJavaType(0) : (mysqlType.equalsIgnoreCase("NUMERIC") ? MysqlDefs.mysqlToJavaType(0) : (mysqlType.equalsIgnoreCase("DOUBLE") ? MysqlDefs.mysqlToJavaType(5) : (mysqlType.equalsIgnoreCase("CHAR") ? MysqlDefs.mysqlToJavaType(254) : (mysqlType.equalsIgnoreCase("VARCHAR") ? MysqlDefs.mysqlToJavaType(253) : (mysqlType.equalsIgnoreCase("DATE") ? MysqlDefs.mysqlToJavaType(10) : (mysqlType.equalsIgnoreCase("TIME") ? MysqlDefs.mysqlToJavaType(11) : (mysqlType.equalsIgnoreCase("YEAR") ? MysqlDefs.mysqlToJavaType(13) : (mysqlType.equalsIgnoreCase("TIMESTAMP") ? MysqlDefs.mysqlToJavaType(7) : (mysqlType.equalsIgnoreCase("DATETIME") ? MysqlDefs.mysqlToJavaType(12) : (mysqlType.equalsIgnoreCase("TINYBLOB") ? -2 : (mysqlType.equalsIgnoreCase("BLOB") ? -4 : (mysqlType.equalsIgnoreCase("MEDIUMBLOB") ? -4 : (mysqlType.equalsIgnoreCase("LONGBLOB") ? -4 : (mysqlType.equalsIgnoreCase("TINYTEXT") ? 12 : (mysqlType.equalsIgnoreCase("TEXT") ? -1 : (mysqlType.equalsIgnoreCase("MEDIUMTEXT") ? -1 : (mysqlType.equalsIgnoreCase("LONGTEXT") ? -1 : (mysqlType.equalsIgnoreCase("ENUM") ? MysqlDefs.mysqlToJavaType(247) : (mysqlType.equalsIgnoreCase("SET") ? MysqlDefs.mysqlToJavaType(248) : (mysqlType.equalsIgnoreCase("GEOMETRY") ? MysqlDefs.mysqlToJavaType(255) : 1111))))))))))))))))))))))))))));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public static String typeToName(int n) {
        String string;
        int mysqlType;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        switch (mysqlType) {
            case 0: {
                string = "FIELD_TYPE_DECIMAL";
                break;
            }
            case 1: {
                string = "FIELD_TYPE_TINY";
                break;
            }
            case 2: {
                string = "FIELD_TYPE_SHORT";
                break;
            }
            case 3: {
                string = "FIELD_TYPE_LONG";
                break;
            }
            case 4: {
                string = "FIELD_TYPE_FLOAT";
                break;
            }
            case 5: {
                string = "FIELD_TYPE_DOUBLE";
                break;
            }
            case 6: {
                string = "FIELD_TYPE_NULL";
                break;
            }
            case 7: {
                string = "FIELD_TYPE_TIMESTAMP";
                break;
            }
            case 8: {
                string = "FIELD_TYPE_LONGLONG";
                break;
            }
            case 9: {
                string = "FIELD_TYPE_INT24";
                break;
            }
            case 10: {
                string = "FIELD_TYPE_DATE";
                break;
            }
            case 11: {
                string = "FIELD_TYPE_TIME";
                break;
            }
            case 12: {
                string = "FIELD_TYPE_DATETIME";
                break;
            }
            case 13: {
                string = "FIELD_TYPE_YEAR";
                break;
            }
            case 14: {
                string = "FIELD_TYPE_NEWDATE";
                break;
            }
            case 247: {
                string = "FIELD_TYPE_ENUM";
                break;
            }
            case 248: {
                string = "FIELD_TYPE_SET";
                break;
            }
            case 249: {
                string = "FIELD_TYPE_TINY_BLOB";
                break;
            }
            case 250: {
                string = "FIELD_TYPE_MEDIUM_BLOB";
                break;
            }
            case 251: {
                string = "FIELD_TYPE_LONG_BLOB";
                break;
            }
            case 252: {
                string = "FIELD_TYPE_BLOB";
                break;
            }
            case 253: {
                string = "FIELD_TYPE_VAR_STRING";
                break;
            }
            case 254: {
                string = "FIELD_TYPE_STRING";
                break;
            }
            case 15: {
                string = "FIELD_TYPE_VARCHAR";
                break;
            }
            case 255: {
                string = "FIELD_TYPE_GEOMETRY";
                break;
            }
            default: {
                string = " Unknown MySQL Type # " + mysqlType;
                break;
            }
        }
        String string2 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    static {
        Factory factory = new Factory("MysqlDefs.java", Class.forName("com.mysql.jdbc.MysqlDefs"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-mysqlToJavaType-com.mysql.jdbc.MysqlDefs-int:-mysqlType:--int-"), 186);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-mysqlToJavaType-com.mysql.jdbc.MysqlDefs-java.lang.String:-mysqlType:--int-"), 322);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-typeToName-com.mysql.jdbc.MysqlDefs-int:-mysqlType:--java.lang.String-"), 391);
    }
}

