/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.Constants;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class ChannelBuffer
extends Buffer {
    private byte[] asBytes = null;
    private int bufLength = 0;
    private ByteBuffer directBuffer;
    private boolean dirty = true;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;
    private static final JoinPoint.StaticPart ajc$tjp_41;
    private static final JoinPoint.StaticPart ajc$tjp_42;
    private static final JoinPoint.StaticPart ajc$tjp_43;

    ChannelBuffer(byte[] buf) {
        this.directBuffer = ByteBuffer.wrap(buf);
        this.setBufLength(buf.length);
    }

    ChannelBuffer(int size, boolean direct) {
        this.directBuffer = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
        this.setBufLength(size);
        this.directBuffer.position(4);
    }

    private byte[] bufferToArray() {
        byte[] byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (!this.dirty) {
            byArray = this.asBytes;
        } else if (this.directBuffer.hasArray()) {
            this.asBytes = this.directBuffer.array();
            this.dirty = false;
            byArray = this.asBytes;
        } else {
            int bufferLength = this.directBuffer.limit();
            this.asBytes = new byte[bufferLength];
            int oldPosition = this.getPosition();
            this.directBuffer.position(0);
            this.directBuffer.get(this.asBytes, 0, bufferLength);
            this.directBuffer.position(oldPosition);
            this.dirty = false;
            byArray = this.asBytes;
        }
        byte[] byArray2 = byArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray2, joinPoint);
        return byArray;
    }

    final void clear() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.directBuffer.position(4);
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void ensureCapacity(int n) throws SQLException {
        void additionalData;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int bufferCapacity = this.directBuffer.capacity();
        int currentPosition = this.directBuffer.position();
        if (currentPosition + additionalData > this.getBufLength()) {
            if (currentPosition + additionalData < bufferCapacity) {
                this.setBufLength(currentPosition + additionalData);
            } else {
                int newLength = (int)((double)bufferCapacity * 1.25);
                if (newLength < 4096) {
                    newLength = 4096;
                }
                if (newLength < bufferCapacity + additionalData) {
                    newLength = bufferCapacity + (int)((double)additionalData * 1.25);
                }
                if (newLength < bufferCapacity) {
                    newLength = bufferCapacity + additionalData;
                }
                ByteBuffer largerBuffer = ByteBuffer.allocateDirect(newLength);
                this.directBuffer.position(0);
                largerBuffer.put(this.directBuffer);
                this.directBuffer = largerBuffer;
                this.directBuffer.position(currentPosition);
                bufferCapacity = this.directBuffer.capacity();
                this.setBufLength(bufferCapacity);
            }
        }
        Object var8_8 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var8_8, joinPoint);
    }

    public int fastSkipLenString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long len = this.readFieldLength();
        this.directBuffer.position((int)((long)this.directBuffer.position() + len));
        int n = (int)len;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    int getBufLength() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.directBuffer.limit();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public byte[] getByteBuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] byArray = this.bufferToArray();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    final byte[] getBytes(int n) {
        void len;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = new byte[len];
        byte[] nioByteBuffer = this.bufferToArray();
        System.arraycopy(nioByteBuffer, this.directBuffer.position(), b, 0, (int)len);
        this.directBuffer.position(this.directBuffer.position() + len);
        byte[] byArray = b;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return b;
    }

    /*
     * WARNING - void declaration
     */
    byte[] getBytes(int n, int n2) {
        void offset;
        void len;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = new byte[len];
        byte[] nioByteBuffer = this.bufferToArray();
        System.arraycopy(nioByteBuffer, (int)offset, b, 0, (int)len);
        this.directBuffer.position((int)(offset + len));
        byte[] byArray = b;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return b;
    }

    int getCapacity() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.directBuffer.capacity();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public ByteBuffer getNioBuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        ByteBuffer byteBuffer = this.directBuffer;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byteBuffer, joinPoint);
        return byteBuffer;
    }

    public int getPosition() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.directBuffer.position();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final boolean isLastDataPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean hasMarker = (this.directBuffer.get(0) & 0xFF) == 254;
        boolean bl = hasMarker && this.bufLength < 9;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    final long newReadLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.directBuffer.get(this.directBuffer.position()) & 0xFF;
        this.directBuffer.position(this.directBuffer.position() + 1);
        switch (sw) {
            case 251: {
                l = 0L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLongLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final byte readByte() {
        byte b;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte by = b = this.directBuffer.get();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.byteObject((byte)by), joinPoint);
        return by;
    }

    /*
     * WARNING - void declaration
     */
    final byte readByte(int n) {
        void readAt;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte by = this.directBuffer.get((int)readAt);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.byteObject((byte)by), joinPoint);
        return by;
    }

    final long readFieldLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.directBuffer.get() & 0xFF;
        switch (sw) {
            case 251: {
                l = -1L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLongLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final int readInt() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.directBuffer.get() & 0xFF | (this.directBuffer.get() & 0xFF) << 8;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final int readIntAsLong() {
        int i;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = i = this.directBuffer.get() & 0xFF | (this.directBuffer.get() & 0xFF) << 8 | (this.directBuffer.get() & 0xFF) << 16 | (this.directBuffer.get() & 0xFF) << 24;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    final byte[] readLenByteArray(int n) {
        byte[] byArray;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long len = this.readFieldLength();
        if (len == -1L) {
            byArray = null;
        } else if (len == 0L) {
            byArray = Constants.EMPTY_BYTE_ARRAY;
        } else {
            void offset;
            this.directBuffer.position(this.directBuffer.position() + offset);
            byArray = this.getBytes((int)len);
        }
        byte[] byArray2 = byArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray2, joinPoint);
        return byArray;
    }

    final long readLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.directBuffer.get() & 0xFF;
        switch (sw) {
            case 251: {
                l = 0L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final long readLong() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l2 = l = (long)(this.directBuffer.get() & 0xFF | (this.directBuffer.get() & 0xFF) << 8 | (this.directBuffer.get() & 0xFF) << 16 | (this.directBuffer.get() & 0xFF) << 24);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l2;
    }

    final int readLongInt() {
        int i;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = i = this.directBuffer.get() & 0xFF | (this.directBuffer.get() & 0xFF) << 8 | (this.directBuffer.get() & 0xFF) << 16;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final long readLongLong() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l2 = l = (long)(this.directBuffer.get() & 0xFF) | (long)(this.directBuffer.get() & 0xFF) << 8 | (long)(this.directBuffer.get() & 0xFF) << 16 | (long)(this.directBuffer.get() & 0xFF) << 24 | (long)(this.directBuffer.get() & 0xFF) << 32 | (long)(this.directBuffer.get() & 0xFF) << 40 | (long)(this.directBuffer.get() & 0xFF) << 48 | (long)(this.directBuffer.get() & 0xFF) << 56;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l2;
    }

    final int readnBytes() {
        int n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.directBuffer.get() & 0xFF;
        switch (sw) {
            case 1: {
                n = this.directBuffer.get() & 0xFF;
                break;
            }
            case 2: {
                n = this.readInt();
                break;
            }
            case 3: {
                n = this.readLongInt();
                break;
            }
            case 4: {
                n = (int)this.readLong();
                break;
            }
            default: {
                n = 255;
                break;
            }
        }
        int n2 = n;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
        return n;
    }

    final String readString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = 0;
        int maxLen = this.getBufLength();
        int oldPosition = this.getPosition();
        while (this.getPosition() < maxLen && this.directBuffer.get() != 0) {
            ++len;
        }
        this.setPosition(oldPosition);
        String s = new String(this.bufferToArray(), this.getPosition(), len);
        this.directBuffer.position(this.getPosition() + len + 1);
        String string = s;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String readString(String string) throws SQLException {
        String string2;
        String string3 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)string3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = 0;
        int maxLen = this.getBufLength();
        while (this.getPosition() < maxLen && this.directBuffer.get() != 0) {
            ++len;
        }
        try {
            void encoding;
            try {
                String string4 = new String(this.bufferToArray(), this.getPosition(), len, (String)encoding);
                Object var4_7 = null;
                this.directBuffer.position(this.getPosition() + len + 1);
                string2 = string4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(String.valueOf(Messages.getString("ChannelBuffer.0")) + (String)encoding + Messages.getString("ChannelBuffer.1"), "S1009");
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.directBuffer.position(this.getPosition() + len + 1);
            throw throwable;
        }
        String string5 = string2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string5, joinPoint);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    void setBufLength(int n) {
        void bufLengthToSet;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.bufLength = bufLengthToSet;
        this.directBuffer.limit(this.bufLength);
        this.dirty = true;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setByteBuffer(byte[] byArray) {
        void byteBuffer;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.directBuffer = ByteBuffer.wrap((byte[])byteBuffer);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setPosition(int n) {
        void position;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.directBuffer.position((int)position);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeByte(byte by) throws SQLException {
        void b;
        byte by2 = by;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)Conversions.byteObject((byte)by2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(1);
        this.directBuffer.put((byte)b);
        this.dirty = true;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeBytesNoNull(byte[] byArray) throws SQLException {
        void bytes;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = ((void)bytes).length;
        this.ensureCapacity(len);
        this.directBuffer.put((byte[])bytes, 0, len);
        this.dirty = true;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeBytesNoNull(byte[] byArray, int n, int n2) throws SQLException {
        void offset;
        void bytes;
        void length;
        byte[] byArray2 = byArray;
        int n3 = n;
        int n4 = n2;
        Object[] objectArray = new Object[]{byArray2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity((int)length);
        this.directBuffer.put((byte[])bytes, (int)offset, (int)length);
        this.dirty = true;
        Object var9_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeDouble(double d) throws SQLException {
        void d2;
        double d3 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d3));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l = Double.doubleToLongBits((double)d2);
        this.writeLongLong(l);
        this.dirty = true;
        Object var8_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var8_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeFieldLength(long l) throws SQLException {
        void length;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (length < 251L) {
            this.writeByte((byte)length);
        } else if (length < 65536L) {
            this.ensureCapacity(3);
            this.writeByte((byte)-4);
            this.writeInt((int)length);
        } else if (length < 0x1000000L) {
            this.ensureCapacity(4);
            this.writeByte((byte)-3);
            this.writeLongInt((int)length);
        } else {
            this.ensureCapacity(9);
            this.writeByte((byte)-2);
            this.writeLongLong((long)length);
        }
        Object var6_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeFloat(float f) throws SQLException {
        void f2;
        float f3 = f;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)Conversions.floatObject((float)f3));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(4);
        int i = Float.floatToIntBits((float)f2);
        this.directBuffer.put((byte)(i & 0xFF));
        this.directBuffer.put((byte)(i >>> 8));
        this.directBuffer.put((byte)(i >>> 16));
        this.directBuffer.put((byte)(i >>> 24));
        this.dirty = true;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeInt(int n) throws SQLException {
        void i;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(2);
        this.directBuffer.put((byte)(i & 0xFF));
        this.directBuffer.put((byte)(i >>> 8));
        this.dirty = true;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLenBytes(byte[] byArray) throws SQLException {
        void b;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = ((void)b).length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        this.directBuffer.put((byte[])b, 0, len);
        this.dirty = true;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLenString(String string, String string2, String string3, SingleByteCharsetConverter singleByteCharsetConverter, boolean bl) throws UnsupportedEncodingException, SQLException {
        void parserKnowsUnicode;
        void serverEncoding;
        void encoding;
        void s;
        void converter;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        SingleByteCharsetConverter singleByteCharsetConverter2 = singleByteCharsetConverter;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{string4, string5, string6, singleByteCharsetConverter2, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = null;
        b = converter != null ? converter.toBytes((String)s) : StringUtils.getBytes((String)s, (String)encoding, (String)serverEncoding, (boolean)parserKnowsUnicode);
        int len = b.length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        this.directBuffer.put(b, 0, len);
        this.dirty = true;
        Object var15_15 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var15_15, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLong(long l) throws SQLException {
        void i;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(4);
        this.directBuffer.put((byte)(i & 0xFFL));
        this.directBuffer.put((byte)(i >>> 8));
        this.directBuffer.put((byte)(i >>> 16));
        this.directBuffer.put((byte)(i >>> 24));
        this.dirty = true;
        Object var6_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLongInt(int n) throws SQLException {
        void i;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(3);
        this.directBuffer.put((byte)(i & 0xFF));
        this.directBuffer.put((byte)(i >>> 8));
        this.directBuffer.put((byte)(i >>> 16));
        this.dirty = true;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLongLong(long l) throws SQLException {
        void i;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(8);
        this.directBuffer.put((byte)(i & 0xFFL));
        this.directBuffer.put((byte)(i >>> 8));
        this.directBuffer.put((byte)(i >>> 16));
        this.directBuffer.put((byte)(i >>> 24));
        this.directBuffer.put((byte)(i >>> 32));
        this.directBuffer.put((byte)(i >>> 40));
        this.directBuffer.put((byte)(i >>> 48));
        this.directBuffer.put((byte)(i >>> 56));
        this.dirty = true;
        Object var6_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeString(String string) throws SQLException {
        void s;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(s.length() * 2 + 1);
        this.writeStringNoNull((String)s);
        this.directBuffer.put((byte)0);
        this.dirty = true;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeStringNoNull(String string) throws SQLException {
        void s;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = s.length();
        this.ensureCapacity(len * 2);
        this.directBuffer.put(s.getBytes(), 0, len);
        this.dirty = true;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeStringNoNull(String string, String string2, String string3, boolean bl) throws UnsupportedEncodingException, SQLException {
        void parserKnowsUnicode;
        void serverEncoding;
        void encoding;
        void s;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{string4, string5, string6, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = StringUtils.getBytes((String)s, (String)encoding, (String)serverEncoding, (boolean)parserKnowsUnicode);
        int len = b.length;
        this.ensureCapacity(len);
        this.directBuffer.put(b, 0, len);
        this.dirty = true;
        Object var13_13 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var13_13, joinPoint);
    }

    static {
        Factory factory = new Factory("ChannelBuffer.java", Class.forName("com.mysql.jdbc.ChannelBuffer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-bufferToArray-com.mysql.jdbc.ChannelBuffer----[B-"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-clear-com.mysql.jdbc.ChannelBuffer----void-"), 94);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPosition-com.mysql.jdbc.ChannelBuffer----int-"), 228);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-isLastDataPacket-com.mysql.jdbc.ChannelBuffer----boolean-"), 233);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-newReadLength-com.mysql.jdbc.ChannelBuffer----long-"), 239);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readByte-com.mysql.jdbc.ChannelBuffer----byte-"), 261);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readByte-com.mysql.jdbc.ChannelBuffer-int:-readAt:--byte-"), 267);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readFieldLength-com.mysql.jdbc.ChannelBuffer----long-"), 271);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readInt-com.mysql.jdbc.ChannelBuffer----int-"), 292);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readIntAsLong-com.mysql.jdbc.ChannelBuffer----int-"), 297);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLenByteArray-com.mysql.jdbc.ChannelBuffer-int:-offset:--[B-"), 308);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLength-com.mysql.jdbc.ChannelBuffer----long-"), 325);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-ensureCapacity-com.mysql.jdbc.ChannelBuffer-int:-additionalData:-java.sql.SQLException:-void-"), 98);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLong-com.mysql.jdbc.ChannelBuffer----long-"), 347);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLongInt-com.mysql.jdbc.ChannelBuffer----int-"), 359);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLongLong-com.mysql.jdbc.ChannelBuffer----long-"), 371);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readnBytes-com.mysql.jdbc.ChannelBuffer----int-"), 386);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readString-com.mysql.jdbc.ChannelBuffer----java.lang.String-"), 415);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readString-com.mysql.jdbc.ChannelBuffer-java.lang.String:-encoding:-java.sql.SQLException:-java.lang.String-"), 434);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-setBufLength-com.mysql.jdbc.ChannelBuffer-int:-bufLengthToSet:--void-"), 455);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setByteBuffer-com.mysql.jdbc.ChannelBuffer-[B:-byteBuffer:--void-"), 467);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setPosition-com.mysql.jdbc.ChannelBuffer-int:-position:--void-"), 478);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeByte-com.mysql.jdbc.ChannelBuffer-byte:-b:-java.sql.SQLException:-void-"), 482);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-fastSkipLenString-com.mysql.jdbc.ChannelBuffer----int-"), 150);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeBytesNoNull-com.mysql.jdbc.ChannelBuffer-[B:-bytes:-java.sql.SQLException:-void-"), 490);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeBytesNoNull-com.mysql.jdbc.ChannelBuffer-[B:int:int:-bytes:offset:length:-java.sql.SQLException:-void-"), 500);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeDouble-com.mysql.jdbc.ChannelBuffer-double:-d:-java.sql.SQLException:-void-"), 508);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeFieldLength-com.mysql.jdbc.ChannelBuffer-long:-length:-java.sql.SQLException:-void-"), 514);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeFloat-com.mysql.jdbc.ChannelBuffer-float:-f:-java.sql.SQLException:-void-"), 533);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeInt-com.mysql.jdbc.ChannelBuffer-int:-i:-java.sql.SQLException:-void-"), 547);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLenBytes-com.mysql.jdbc.ChannelBuffer-[B:-b:-java.sql.SQLException:-void-"), 557);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLenString-com.mysql.jdbc.ChannelBuffer-java.lang.String:java.lang.String:java.lang.String:com.mysql.jdbc.SingleByteCharsetConverter:boolean:-s:encoding:serverEncoding:converter:parserKnowsUnicode:-java.io.UnsupportedEncodingException:java.sql.SQLException:-void-"), 570);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLong-com.mysql.jdbc.ChannelBuffer-long:-i:-java.sql.SQLException:-void-"), 589);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLongInt-com.mysql.jdbc.ChannelBuffer-int:-i:-java.sql.SQLException:-void-"), 601);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBufLength-com.mysql.jdbc.ChannelBuffer----int-"), 160);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLongLong-com.mysql.jdbc.ChannelBuffer-long:-i:-java.sql.SQLException:-void-"), 611);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeString-com.mysql.jdbc.ChannelBuffer-java.lang.String:-s:-java.sql.SQLException:-void-"), 627);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeStringNoNull-com.mysql.jdbc.ChannelBuffer-java.lang.String:-s:-java.sql.SQLException:-void-"), 637);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeStringNoNull-com.mysql.jdbc.ChannelBuffer-java.lang.String:java.lang.String:java.lang.String:boolean:-s:encoding:serverEncoding:parserKnowsUnicode:-java.io.UnsupportedEncodingException:java.sql.SQLException:-void-"), 650);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getByteBuffer-com.mysql.jdbc.ChannelBuffer----[B-"), 169);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-getBytes-com.mysql.jdbc.ChannelBuffer-int:-len:--[B-"), 173);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBytes-com.mysql.jdbc.ChannelBuffer-int:int:-offset:len:--[B-"), 195);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getCapacity-com.mysql.jdbc.ChannelBuffer----int-"), 211);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getNioBuffer-com.mysql.jdbc.ChannelBuffer----java.nio.ByteBuffer-"), 215);
    }
}

