/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import org.eclipse.jdt.core.compiler.CharOperation;

public class QualifiedNameSet {
    public char[][][] qualifiedNames;
    public int elementSize;
    public int threshold;

    public QualifiedNameSet(int size) {
        if (size < 3) {
            size = 3;
        }
        this.elementSize = 0;
        this.threshold = size + 1;
        this.qualifiedNames = new char[2 * size + 1][][];
    }

    public char[][] add(char[][] qualifiedName) {
        char[][] current;
        int qLength = qualifiedName.length;
        if (qLength == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int length = this.qualifiedNames.length;
        int index = CharOperation.hashCode(qualifiedName[qLength - 1]) % length;
        while ((current = this.qualifiedNames[index]) != null) {
            if (CharOperation.equals(current, qualifiedName)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        this.qualifiedNames[index] = qualifiedName;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return qualifiedName;
    }

    private void rehash() {
        QualifiedNameSet newSet = new QualifiedNameSet(this.elementSize * 2);
        int i = this.qualifiedNames.length;
        while (--i >= 0) {
            char[][] current = this.qualifiedNames[i];
            if (current == null) continue;
            newSet.add(current);
        }
        this.qualifiedNames = newSet.qualifiedNames;
        this.elementSize = newSet.elementSize;
        this.threshold = newSet.threshold;
    }

    public String toString() {
        String s = "";
        int i = 0;
        int l = this.qualifiedNames.length;
        while (i < l) {
            char[][] qualifiedName = this.qualifiedNames[i];
            if (qualifiedName != null) {
                s = String.valueOf(s) + CharOperation.toString(qualifiedName) + "\n";
            }
            ++i;
        }
        return s;
    }
}

