/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;

public class VariableDeclarationFragment
extends VariableDeclaration {
    private SimpleName variableName = null;
    private int extraArrayDimensions = 0;
    private Expression optionalInitializer = null;

    VariableDeclarationFragment(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 59;
    }

    ASTNode clone(AST target) {
        VariableDeclarationFragment result = new VariableDeclarationFragment(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setName((SimpleName)this.getName().clone(target));
        result.setExtraDimensions(this.getExtraDimensions());
        result.setInitializer((Expression)ASTNode.copySubtree(target, this.getInitializer()));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getName());
            this.acceptChild(visitor, this.getInitializer());
        }
        visitor.endVisit(this);
    }

    public SimpleName getName() {
        if (this.variableName == null) {
            long count = this.getAST().modificationCount();
            this.setName(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.variableName;
    }

    public void setName(SimpleName variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.variableName, variableName, false);
        this.variableName = variableName;
    }

    public int getExtraDimensions() {
        return this.extraArrayDimensions;
    }

    public void setExtraDimensions(int dimensions) {
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.extraArrayDimensions = dimensions;
    }

    public Expression getInitializer() {
        return this.optionalInitializer;
    }

    public void setInitializer(Expression initializer) {
        this.replaceChild(this.optionalInitializer, initializer, true);
        this.optionalInitializer = initializer;
    }

    int memSize() {
        return 52;
    }

    int treeSize() {
        return this.memSize() + (this.variableName == null ? 0 : this.getName().treeSize()) + (this.optionalInitializer == null ? 0 : this.getInitializer().treeSize());
    }
}

