/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class TypeDeclarationStatement
extends Statement {
    private TypeDeclaration typeDecl = null;

    TypeDeclarationStatement(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 56;
    }

    ASTNode clone(AST target) {
        TypeDeclarationStatement result = new TypeDeclarationStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setTypeDeclaration((TypeDeclaration)this.getTypeDeclaration().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getTypeDeclaration());
        }
        visitor.endVisit(this);
    }

    public TypeDeclaration getTypeDeclaration() {
        if (this.typeDecl == null) {
            long count = this.getAST().modificationCount();
            this.setTypeDeclaration(new TypeDeclaration(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.typeDecl;
    }

    public void setTypeDeclaration(TypeDeclaration decl) {
        if (decl == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.typeDecl, decl, true);
        this.typeDecl = decl;
    }

    public ITypeBinding resolveBinding() {
        TypeDeclaration d = this.getTypeDeclaration();
        return d.resolveBinding();
    }

    int memSize() {
        return super.memSize() + 4;
    }

    int treeSize() {
        return this.memSize() + (this.typeDecl == null ? 0 : this.getTypeDeclaration().treeSize());
    }
}

