/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IHierarchyListener;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.AspectJElementHierarchy;
import org.aspectj.asm.internal.RelationshipMap;
import org.aspectj.bridge.ISourceLocation;

public class AsmManager {
    private static AsmManager INSTANCE = new AsmManager();
    private boolean shouldSaveModel = true;
    protected IHierarchy hierarchy;
    private List structureListeners = new ArrayList();
    private IRelationshipMap mapper;
    private CanonicalFilePathMap canonicalFilePathMap = new CanonicalFilePathMap();

    protected AsmManager() {
        this.hierarchy = new AspectJElementHierarchy();
        this.mapper = new RelationshipMap(this.hierarchy);
    }

    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public static AsmManager getDefault() {
        return INSTANCE;
    }

    public IRelationshipMap getRelationshipMap() {
        return this.mapper;
    }

    public void fireModelUpdated() {
        this.notifyListeners();
        if (this.hierarchy.getConfigFile() != null) {
            this.writeStructureModel(this.hierarchy.getConfigFile());
        }
    }

    public HashMap getInlineAnnotations(String sourceFile, boolean showSubMember, boolean showMemberAndType) {
        if (!this.hierarchy.isValid()) {
            return null;
        }
        HashMap annotations = new HashMap();
        IProgramElement node = this.hierarchy.findElementForSourceFile(sourceFile);
        if (node == IHierarchy.NO_STRUCTURE) {
            return null;
        }
        IProgramElement fileNode = node;
        ArrayList peNodes = new ArrayList();
        this.getAllStructureChildren(fileNode, peNodes, showSubMember, showMemberAndType);
        Iterator it = ((AbstractList)peNodes).iterator();
        while (it.hasNext()) {
            IProgramElement peNode = (IProgramElement)it.next();
            ArrayList<IProgramElement> entries = new ArrayList<IProgramElement>();
            entries.add(peNode);
            ISourceLocation sourceLoc = peNode.getSourceLocation();
            if (null == sourceLoc) continue;
            Integer hash = new Integer(sourceLoc.getLine());
            List existingEntry = (List)annotations.get(hash);
            if (existingEntry != null) {
                entries.addAll(existingEntry);
            }
            annotations.put(hash, entries);
        }
        return annotations;
    }

    private void getAllStructureChildren(IProgramElement node, List result, boolean showSubMember, boolean showMemberAndType) {
        List children = node.getChildren();
        if (node.getChildren() == null) {
            return;
        }
        Iterator it = children.iterator();
        while (it.hasNext()) {
            IProgramElement next = (IProgramElement)it.next();
            List rels = AsmManager.getDefault().getRelationshipMap().get(next);
            if (next != null && (next.getKind() == IProgramElement.Kind.CODE && showSubMember || next.getKind() != IProgramElement.Kind.CODE && showMemberAndType) && rels != null && rels.size() > 0) {
                result.add(next);
            }
            this.getAllStructureChildren(next, result, showSubMember, showMemberAndType);
        }
    }

    public void addListener(IHierarchyListener listener) {
        this.structureListeners.add(listener);
    }

    public void removeStructureListener(IHierarchyListener listener) {
        this.structureListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.structureListeners.clear();
    }

    private void notifyListeners() {
        Iterator it = this.structureListeners.iterator();
        while (it.hasNext()) {
            ((IHierarchyListener)it.next()).elementsUpdated(this.hierarchy);
        }
    }

    public void writeStructureModel(String configFilePath) {
        try {
            String filePath = this.genExternFilePath(configFilePath);
            ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(filePath));
            s.writeObject(this.hierarchy);
            s.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readStructureModel(String configFilePath) {
        try {
            block5: {
                try {
                    if (configFilePath == null) {
                        this.hierarchy.setRoot(IHierarchy.NO_STRUCTURE);
                        break block5;
                    }
                    String filePath = this.genExternFilePath(configFilePath);
                    FileInputStream in = new FileInputStream(filePath);
                    ObjectInputStream s = new ObjectInputStream(in);
                    this.hierarchy = (AspectJElementHierarchy)s.readObject();
                }
                catch (Exception e) {
                    this.hierarchy.setRoot(IHierarchy.NO_STRUCTURE);
                    Object var6_7 = null;
                    this.notifyListeners();
                }
            }
            Object var6_6 = null;
            this.notifyListeners();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.notifyListeners();
            throw throwable;
        }
    }

    private String genExternFilePath(String configFilePath) {
        return configFilePath.substring(0, configFilePath.lastIndexOf(".lst")) + ".ajsym";
    }

    public void setShouldSaveModel(boolean shouldSaveModel) {
        this.shouldSaveModel = shouldSaveModel;
    }

    public String getCanonicalFilePath(File f) {
        return this.canonicalFilePathMap.get(f);
    }

    private static class CanonicalFilePathMap {
        private static final int MAX_SIZE = 4000;
        private Map pathMap = new HashMap(4000);

        private CanonicalFilePathMap() {
        }

        public String get(File f) {
            String ret = (String)this.pathMap.get(f.getPath());
            if (ret == null) {
                try {
                    ret = f.getCanonicalPath();
                }
                catch (IOException ioEx) {
                    ret = f.getPath();
                }
                this.pathMap.put(f.getPath(), ret);
                if (this.pathMap.size() > 4000) {
                    this.pathMap.clear();
                }
            }
            return ret;
        }
    }
}

