import java.io.*;
import java.awt.*;
import java.awt.event.*;


public class Ventana extends Frame implements ActionListener{
	static public void main(String[]args) throws Exception{
		new Ventana().show();
	}
	//componentes
	
	private TextField numero=new TextField(),monto=new TextField();
	private Label respuesta=new Label();
	private Button
		girar = new Button("girar"), depositar = new Button("depositar"),
		consultar = new Button("consultar"), quit = new Button("quit");
	
	//constructor
	
	public Ventana(){
		setLayout(new GridLayout(5,2)); setSize(200,5*50);
		add(new Label("N cuenta?")); add(numero);
		add(girar);add(depositar);add(consultar);add(quit);
		add(new Label("monto?")); add(monto);
		add(new Label("respuesta:")); add(respuesta);
		numero.addActionListener(this);
		girar.addActionListener(this); depositar.addActionListener(this);
		consultar.addActionListener(this); quit.addActionListener(this);
	}
	
	//mtodo actionPerformed
	
	private Cuenta1 cuenta=null;
	public void actionPerformed(ActionEvent x){
		if(x.getSource()==quit)
			System.exit(0);
		if(x.getSource()==numero){
			cuenta=null;
			//buscar en archivo
			String s=numero.getText();
			
			try {
				BufferedReader a=new BufferedReader(new FileReader("banco.txt"));
			
				String linea;
				while((linea=a.readLine())!=null)
					if(linea.substring(0,10).equals(s))
						break;	
				if( linea==null)
					respuesta.setText("cuenta inexistente");
				else if( linea.charAt(20)=='1')
					cuenta=new Cuenta1(linea.substring(0,20));
				else
					cuenta=new Cuenta1(linea.substring(0,20));
				respuesta.setText("cuenta correcta");
			}
			catch(Exception e){
				System.out.println("Error en la lectura.");
			}
			return;
		}
		if(cuenta==null)
			respuesta.setText("cuenta inexistente");
		else if(x.getSource()==consultar)
			respuesta.setText("saldo="+cuenta.consultar());
		else if(x.getSource()==depositar){
			cuenta.depositar(Integer.parseInt(monto.getText()));
			respuesta.setText("nuevo saldo="+cuenta.consultar());
		}
		else if(x.getSource()==girar){
			if(cuenta.girar(Integer.parseInt(monto.getText())))
				respuesta.setText("nuevo saldo="+cuenta.consultar());
			else
				respuesta.setText("saldo insuficiente");
		}
		
	}
}
