
function x = secant(func,x0,param,crit,maxit);

% secant.m   Program to solve a non-linear simultaneous equation system.
%         x=newton(func,x0,param,crit,maxit) uses Newton-Raphson's method
%         with numerical derivatives to solve:
%
%                        f1(z1,z2,...zn)=0
%                        f2(z1,z2,...zn)=0                (*)
%                          :           :
%                        fn(z1,z2,...zn)=0
%
%         where x=[z1,z2,...,zn]' is a vector solving (*).
%
%	  		 To use this function, need to specify func, a string with
%         the name of a .m file with the function f. If needed, can use 
%         vector param to include additional parameters for this function.
%
%         The arguments x0, crit, and maxit are the initial guess for x,
%         the tolerance criterion and the maximum number of iterations 
%         allowed before stopping the program.
%

del = diag(max(abs(x0)*1e-4,1e-8));
n   = length(x0);

for i=1:maxit
  	f  = feval(func,x0,param);
  	for j=1:n
    	    J(:,j) = (f-feval(func,x0-del(:,j),param))/del(j,j);
  	end;
  	x  = x0-inv(J)*f;
  	if norm(x-x0)<crit 
    	    break 
  	end
  	x0 = x;
end

if i>=maxit 
   sprintf('WARNING: Maximum number of %g iterations reached',maxit)
end
