
function x = newton(func,x0,param,crit,maxit);

% newton.m   Program to solve a non-linear simultaneous equation system.
%         x=newton(func,x0,param,crit,maxit) uses Newton-Raphson's method
%         to solve:
%
%                        f1(z1,z2,...zn)=0
%                        f2(z1,z2,...zn)=0                (*)
%                          :           :
%                        fn(z1,z2,...zn)=0
%
%         where x=[z1,z2,...,zn]' is a vector solving (*).
%
%	  		 To use this function, need to specify func, a string with
%         the name of a .m file with the function f and its Jacobian 
%         matrix J. If needed, can use vector param to include additional
%         parameters for this function.
%
%         The arguments x0, crit, and maxit are the initial guess for x,
%         the tolerance criterion and the maximum number of iterations 
%         allowed before stopping the program.
%

for i=1:maxit
  	[f,J] = feval(func,x0,param);
  	x     = x0-inv(J)*f;
  	if norm(x-x0)<crit 
    	   break 
  	end
  	x0 = x;
end

if i>=maxit 
   sprintf('WARNING: Maximum number of %g iterations reached',maxit)
end
