
%t_list={'trainlm', 'trainbfg', 'trainrp', 'trainscg', 'traincgb', 'traincgf', 'traincgp', 'trainoss', 'traingdx'}; 
clear
load choles_all;
[pn,meanp,stdp,tn,meant,stdt] = prestd(p,t);
[ptrans,transMat] = prepca(pn,0.001);
[R,Q] = size(ptrans);
iitst = 2:4:Q;
iival = 4:4:Q;
iitr = [1:4:Q 3:4:Q];

val.P = ptrans(:,iival);
val.T = tn(:,iival);

test.P = ptrans(:,iitst);
test.T = tn(:,iitst);

ptr = ptrans(:,iitr);
ttr = tn(:,iitr);

net = newff(minmax(ptr),[5 3], {'tansig', 'purelin'}, 'traingdx');

net.trainParam.show=10;
net.trainParam.lr=0.05;
net.trainParam.epochs=300;
net.trainParam.goal=1e-7;

[net, tr] = train(net, ptr, ttr, [], [], val, test);

plot(tr.epoch, tr.perf, tr.epoch, tr.vperf, tr.epoch, tr.tperf)
legend('Entrenamiento', 'Validacion', 'Test', +1);
ylabel('MSE');
xlabel('Epocas');

