function nnd15gl1(cmd,arg1,arg2,arg3)
%NND15GL1 Grossberg layer 1 demonstration.

% $Revision: 1.7 $ $Date: 2002/03/25 16:51:11 $
% Copyright 1994-2002 PWS Publishing Company and The MathWorks, Inc.
% First Version, 8-31-95.

%==================================================================

% GLOBALS
global p;
global bp;
global bn;
global e;

% CONSTANTS
Fs = 8192;
W1p = eye(2);
W1n = ones(2)-eye(2);

% DEFAULTS
if nargin == 0, cmd = ''; else cmd = lower(cmd); end

% FIND WINDOW IF IT EXISTS
fig = nndfgflg(mfilename);
if length(get(fig,'children')) == 0, fig = 0; end

% GET WINDOW DATA IF IT EXISTS
if fig
  H = get(fig,'userdata');
  fig_axis = H(1);         % window axis
  desc_text = H(2);        % handle to first line of text sequence
  big_axis = H(3);         % Big axis
  pp_bar = H(4);
  pp_text = H(5);
  pn_bar = H(6);
  pn_text = H(7);
  bp_bar = H(8);
  bp_text = H(9);
  bn_bar = H(10);
  bn_text = H(11);
  e_bar = H(12);
  e_text = H(13);
  old_ptr = H(14);
  last_ptr = H(15);
  big_line = H(16);
end

%==================================================================
% Activate the window.
%
% MFILENAME() or MFILENAME('')
%==================================================================

if strcmp(cmd,'')
  if fig
    figure(fig)
    set(fig,'visible','on')
  else
    feval(mfilename,'init')
  end

%==================================================================
% Close the window.
%
% MFILENAME() or MFILENAME('')
%==================================================================

elseif strcmp(cmd,'close') & (fig)
  delete(fig)

%==================================================================
% Initialize the window.
%
% MFILENAME('init')
%==================================================================

elseif strcmp(cmd,'init') & (~fig)

  % CONSTANTS
  pp = 1;
  pn = 0;
  bp = 1;
  bn = 0;
  e = 1;
  p = [pp; pn];

  % NEW DEMO FIGURE
  fig = nndemof2(mfilename,'DESIGN','Grossberg Layer 1','','Chapter 15');

  set(fig, ...
    'windowbuttondownfcn',nncallbk(mfilename,'down'), ...
    'BackingStore','off',...
    'nextplot','add');
  H = get(fig,'userdata');
  fig_axis = H(1);
  desc_text = H(2);

  % ICON
  nndicon(15,458,363,'shadow')

  % FIRST INPUT SLIDER BAR
  x = 40;
  y = 150;
  len = 140;
  text(x,y,'Input p(1):',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','left')
  pp_text = text(x+len,y,sprintf('%3.1f',pp),...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','right');
  text(x,y-36,'0.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','left')
  text(x+len,y-36,'10.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','right');
  pp_bar = uicontrol(...
    'units','points',...
    'position',[x y-25 len 16],...
    'style','slider',...
    'backg',nnltgray,...
    'callback',[mfilename '(''pp'')'],...
    'min',0,...
    'max',10,...
    'value',pp);

  % SECOND INPUT SLIDER BAR
  x = 40;
  y = 100;
  len = 140;
  text(x,y,'Input: p(2)',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','left')
  pn_text = text(x+len,y,sprintf('%3.1f',pn),...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','right');
  text(x,y-36,'0.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','left')
  text(x+len,y-36,'10.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','right');
  pn_bar = uicontrol(...
    'units','points',...
    'position',[x y-25 len 16],...
    'style','slider',...
    'backg',nnltgray,...
    'callback',[mfilename '(''pn'')'],...
    'min',0,...
    'max',10,...
    'value',pn);

  % EXCITITORY BIAS SLIDER BAR
  x = 210;
  y = 150;
  len = 140;
  text(x,y,'Bias b+:',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','left')
  bp_text = text(x+len,y,sprintf('%3.1f',bp),...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','right');
  text(x,y-36,'0.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','left')
  text(x+len,y-36,'5.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','right');
  bp_bar = uicontrol(...
    'units','points',...
    'position',[x y-25 len 16],...
    'style','slider',...
    'backg',nnltgray,...
    'callback',[mfilename '(''bp'')'],...
    'min',0,...
    'max',5,...
    'value',bp);

  % INHIBITORY BIAS SLIDER BAR
  x = 210;
  y = 100;
  len = 140;
  text(x,y,'Bias b-:',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','left')
  bn_text = text(x+len,y,sprintf('%3.1f',bn),...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','right');
  text(x,y-36,'0.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','left')
  text(x+len,y-36,'5.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','right');
  bn_bar = uicontrol(...
    'units','points',...
    'position',[x y-25 len 16],...
    'style','slider',...
    'backg',nnltgray,...
    'callback',[mfilename '(''bn'')'],...
    'min',0,...
    'max',5,...
    'value',bn);

  % TIME CONSTANT SLIDER BAR
  x = 40;
  y = 50;
  len = 310;
  text(x,y,'Time Constant (eps):',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','left')
  e_text = text(x+len,y,sprintf('%3.1f',e),...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',12,...
    'horizontalalignment','right');
  text(x,y-36,'0.1',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','left')
  text(x+len,y-36,'5.0',...
    'color',nndkblue,...
    'fontw','bold',...
    'fontsize',10,...
    'horizontalalignment','right');
  e_bar = uicontrol(...
    'units','points',...
    'position',[x y-25 len 16],...
    'style','slider',...
    'backg',nnltgray,...
    'callback',[mfilename '(''time'')'],...
    'min',0.1,...
    'max',5,...
    'value',e);

  % BIG AXES
  big_axis = nnsfo('a1','Response','Time','Net Inputs n1(1), n1(2)');
  set(big_axis,...
    'position',[50 190 300 140],...
    'xlim',[-0.1 5.1],...
    'xtick',0:5,...
    'ylim',[-5.5 5.5],...
    'ytick',-5:2.5:5)
  big_line = plot3([0 5],[0 0],[1 1],'--',...
    'color',nndkblue);
  view(2)

  % PLOT RESPONSE
  [T,Y] = ode45('nndlay1',[0 5],[0;0]);
  Y = Y';
  set(fig,'nextplot','add')
  last1 = plot(T,Y(1,:),...
    'color',nnred,...
    'linewidth',2);
  last2 = plot(T,Y(2,:),...
    'color',nngreen,...
    'linewidth',2);
  last = [last1; last2];

  % BUTTONS
  uicontrol(...
    'units','points',...
    'position',[410 130 60 20],...
    'string','Clear',...
    'callback',[mfilename '(''clear'')'])
  uicontrol(...
    'units','points',...
    'position',[410 95 60 20],...
    'string','Contents',...
    'callback','nndtoc')
  uicontrol(...
    'units','points',...
    'position',[410 60 60 20],...
    'string','Close',...
    'callback',[mfilename '(''close'')'])

  % SAVE WINDOW DATA AND LOCK
  old_ptr = uicontrol('visible','off','userdata',[]);
  last_ptr = uicontrol('visible','off','userdata',last);

  H = [fig_axis, ...
       desc_text,...
       big_axis, ...
       pp_bar pp_text pn_bar pn_text, ...
       bp_bar bp_text bn_bar bn_text e_bar e_text,...
       old_ptr, last_ptr,...
       big_line];

  set(fig,'userdata',H,'nextplot','new')

  % INSTRUCTION TEXT
  feval(mfilename,'instr');

  % LOCK WINDOW
  set(fig,...
   'nextplot','new',...
   'color',nnltgray);
  drawnow

  nnchkfs;

%==================================================================
% Display the instructions.
%
% MFILENAME('instr')
%==================================================================

elseif strcmp(cmd,'instr') & (fig)
  nnsettxt(desc_text,...
    'Use the slider bars',...
    'to adjust the inputs,',...
    'biases, and time',...
    'constant.',...
    '',...
    'Output n1(1) is',...
    'in red, output n1(2)',...
    'is shown as green.',...
    '',...
    'Click [Clear] to',...
    'remove old',...
    'responses.')
    
%==================================================================
% Clear input vectors.
%
% MFILENAME('clear')
%==================================================================

elseif strcmp(cmd,'clear') & (fig) & (nargin == 1)
  
  % GET DATA
  old = get(old_ptr,'userdata');
  last = get(last_ptr,'userdata');

  % REMOVE OLD
  delete(old);
  
  % SAVE DATA
  set(old_ptr,'userdata',[]);

%==================================================================
% Respond to excitatory input slider.
%
% MFILENAME('pp')
%==================================================================

elseif strcmp(cmd,'pp')
  
  % GET DATA
  pp = get(pp_bar,'value');

  % UPDATE BAR
  set(pp_text,'string',sprintf('%3.1f',pp))

  % UPDATE RESPONSE
  cmd = 'update';

%==================================================================
% Respond to inhibitory input slider.
%
% MFILENAME('pn')
%==================================================================

elseif strcmp(cmd,'pn')
  
  % GET DATA
  pn = get(pn_bar,'value');

  % UPDATE BAR
  set(pn_text,'string',sprintf('%3.1f',pn))

  % UPDATE RESPONSE
  cmd = 'update';

%==================================================================
% Respond to upper bias slider.
%
% MFILENAME('bp')
%==================================================================

elseif strcmp(cmd,'bp')
  
  % GET DATA
  bp = get(bp_bar,'value');

  % UPDATE BAR
  set(bp_text,'string',sprintf('%3.1f',bp))

  % UPDATE RESPONSE
  cmd = 'update';

%==================================================================
% Respond to lower bias slider.
%
% MFILENAME('bn')
%==================================================================

elseif strcmp(cmd,'bn')
  
  % GET DATA
  bn = get(bn_bar,'value');

  % UPDATE BAR
  set(bn_text,'string',sprintf('%3.1f',bn))

  % UPDATE RESPONSE
  cmd = 'update';

%==================================================================
% Respond to time constant slider.
%
% MFILENAME('time')
%==================================================================

elseif strcmp(cmd,'time')
  
  % GET DATA
  e = get(e_bar,'value');

  % UPDATE BAR
  set(e_text,'string',sprintf('%3.1f',e))

  % UPDATE RESPONSE
  cmd = 'update';
end

%==================================================================
% Respond to time constant slider.
%
% MFILENAME('update')
%==================================================================

if strcmp(cmd,'update')

  % GET DATA
  pp = get(pp_bar,'value');
  pn = get(pn_bar,'value');
  bp = get(bp_bar,'value');
  bn = get(bn_bar,'value');
  e = get(e_bar,'value');
  old = get(old_ptr,'userdata');
  last = get(last_ptr,'userdata');
  p = [pp; pn];

  % MAKE LAST LINE OLD
  set(last,'color',nndkgray);
  old = [old last];
  if size(old,2) > 1
    gone = old(:,1);
    old(:,1) = [];
  else
    gone = [];
  end
  set(old,'color',nnltgray)
  drawnow
  delete(gone);

  % PLOT RESPONSE
  [T,Y] = ode45('nndlay1',[0 5],[0;0]);
  Y = Y';
  set(fig,'nextplot','add')
  axes(big_axis)
  set(big_line,'color',nndkblue)
  last1 = plot(T,Y(1,:),...
    'color',nnred,...
    'linewidth',2);
  last2 = plot(T,Y(2,:),...
    'color',nngreen,...
    'linewidth',2);
  last = [last1; last2];
  set(fig,'nextplot','new')

  % SAVE DATA
  set(old_ptr,'userdata',old);
  set(last_ptr,'userdata',last);
end
