function nndataimport(cmd,arg1,arg2,arg3)
%NNDATAIMPORT Data Import GUI for the Neural Network Controller Toolbox.
%
%  Synopsis
%
%    nndataimport(cmd,arg1,arg2,arg3)
%
%  Warning!!
%
%    This function may be altered or removed in future
%    releases of the Neural Network Toolbox. We recommend
%    you do not write code which calls this function.
%    This function is generally being called from a Simulink block.

% Orlando De Jesus, Martin Hagan, 1-25-00
% Copyright 1992-2002 The MathWorks, Inc.
% $Revision: 1.5 $ $Date: 2002/03/25 16:55:15 $


% CONSTANTS
me = 'Import Data.';

% DEFAULTS
if nargin == 0, cmd = ''; else cmd = lower(cmd); end

% FIND WINDOW IF IT EXISTS
fig=findall(0,'type','figure','name',me);
if (size(fig,1)==0), fig=0; end

if length(get(fig,'children')) == 0, fig = 0; end

if fig
   ud = get(fig,'userdata');
end

if strcmp(cmd,'init')
  if fig==0  
    StdColor = get(0,'DefaultFigureColor');
    PointsToPixels = 72/get(0,'ScreenPixelsPerInch');
    StdUnit = 'points';
    ud.Handles.parent=arg1;
    ud.Handles.type_net=arg2;
    
    fig = figure('Units','points', ...
      'Interruptible','off', ...
      'BusyAction','cancel', ...
      'HandleVis','Callback', ...
    'Color',StdColor, ...
    'IntegerHandle','off', ...
    'MenuBar','none', ...
    'Name',me, ...
    'NumberTitle','off', ...
    'PaperUnits','points', ...
    'Position',PointsToPixels*[7 94 526 215], ...
    'Tag','ImportIACfig', ...
     'WindowStyle','modal');
   h1 = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'Position',PointsToPixels*[11 9 165 125], ...
    'Style','frame');
   h1 = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'Position',PointsToPixels*[11 142 165 55], ...
    'Style','frame');
   h1 = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'Position',PointsToPixels*[54 120 81 20], ...
    'String','Import From:', ...
    'Style','text');
   h1 = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'Position',PointsToPixels*[49 182 91 20], ...
    'String','Type of Data:', ...
    'Style','text');
   ud.Handles.Sbutton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'Callback','nncontrolutil(''nndataimport'',''radiobutton1'',gcbf);nncontrolutil(''nndataimport'',''structures'',gcbf);', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[20 167 100 19], ...
    'String','Structures', ...
    'Style','radiobutton', ...
      'ToolTipStr','If selected, the data will be expected in structure form (e.g., tr_dat.U and tr_dat.Y).',...
    'Tag','Mbutton',...
    'Value',1);
   ud.Handles.Abutton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'Callback','nncontrolutil(''nndataimport'',''radiobutton1'',gcbf);nncontrolutil(''nndataimport'',''arrays'',gcbf);', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[20 144 100 19], ...
    'String','Arrays', ...
    'Style','radiobutton', ...
    'Tag','Wbutton', ...
      'ToolTipStr','If selected, the data will be expected in array form - one for input and one for output.');
   set(ud.Handles.Abutton,'UserData',[ud.Handles.Sbutton]);
   set(ud.Handles.Sbutton,'UserData',[ud.Handles.Abutton]);
   ud.Handles.Wbutton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'Callback','nncontrolutil(''nndataimport'',''radiobutton'',gcbf);nncontrolutil(''nndataimport'',''workspace'',gcbf);', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[20 105 100 19], ...
    'String','Workspace', ...
    'Style','radiobutton', ...
    'Tag','Wbutton', ...
      'ToolTipStr','If selected, the data will be taken from the MATLAB workspace.',...
    'Value',1);
   ud.Handles.Mbutton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'Callback','nncontrolutil(''nndataimport'',''radiobutton'',gcbf);nncontrolutil(''nndataimport'',''matfile'',gcbf);', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[20 81 100 19], ...
    'String','MAT-file', ...
    'Style','radiobutton', ...
      'ToolTipStr','If selected, the data will be taken from a MAT-file.',...
    'Tag','Mbutton');
   set(ud.Handles.Wbutton,'UserData',[ud.Handles.Mbutton]);
   set(ud.Handles.Mbutton,'UserData',[ud.Handles.Wbutton]);
   ud.Handles.FileNameText = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
     'Enable','off', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[20 58 141 20], ...
    'String','MAT-filename:', ...
    'Style','text', ...
      'ToolTipStr','Enter the name of the MAT-file containing the data.',...
    'Tag','FileNameText');
   ud.Handles.FileNameEdit = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',[1 1 1], ...
     'Enable','off', ...
    'Callback','nncontrolutil(''nndataimport'',''clearpath'',gcbf);nncontrolutil(''nndataimport'',''matfile'',gcbf);', ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[20 39 141 20], ...
    'String','', ...
    'Style','edit', ...
      'ToolTipStr','Enter the name of the MAT-file containing the data.',...
    'Tag','FileNameEdit');
   ud.Handles.BrowseButton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
     'Enable','off', ...
    'Callback','nncontrolutil(''nndataimport'',''browsemat'',gcbf);', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[20 14 142 20], ...
    'String','Browse', ...
      'ToolTipStr','Browse the disk to select a MAT-file.',...
    'Tag','BrowseButton');
   h1 = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[179 44 149 153], ...
    'Style','frame');
   ud.Handles.ModelText = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[193 184 123 20], ...
    'String','Workspace Contents', ...
    'Style','text', ...
    'Tag','ModelText');
   ud.Handles.ModelList = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',[1 1 1], ...
    'Position',PointsToPixels*[187 49 134 139], ...
    'Style','listbox', ...
    'Tag','ModelList', ...
      'ToolTipStr','Present the data found in the MATLAB workspace or MAT-file.',...
    'Value',1);
   h1 = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[369 44 149 153], ...
    'Style','frame');
   h1 = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[379 184 130 20], ...
    'String','Input Output Variables', ...
    'Style','text');
    EditUd = struct('ListIndex',0,'String','');
    ud.Handles.DataText = uicontrol('Parent',fig, ...
     'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[383 153 120 22], ...
    'String','Structure Name:', ...
    'Style','text', ...
      'Tag','DataText');
   ud.Handles.DataEdit = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','nncontrolutil(''nndataimport'',''editcallback'',gcbf);', ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[383 139 125 20], ...
    'String','', ...
    'Style','edit', ...
     'UserData',EditUd,...
      'ToolTipStr','Data object to be imported.',...
    'Tag','DataEdit');
   ud.Handles.DataButton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'Callback','nncontrolutil(''nndataimport'',''buttoncallback'',gcbf);', ...
    'Position',PointsToPixels*[336 139 25 21], ...
    'String','-->', ...
     'UserData',ud.Handles.DataEdit,...
      'ToolTipStr','Select the data object to be imported.',...
    'Tag','DataButton');
    ud.Handles.InputText = uicontrol('Parent',fig, ...
     'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[383 110 70 22], ...
    'String','Input Array:', ...
    'Style','text', ...
      'Tag','InputText');
   ud.Handles.InputEdit = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','nncontrolutil(''nndataimport'',''editcallback'',gcbf);', ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[383 96 125 20], ...
    'String','', ...
    'Style','edit', ...
     'UserData',EditUd,...
      'ToolTipStr','Input data array to be imported.',...
    'Tag','InputEdit');
   ud.Handles.InputButton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'Callback','nncontrolutil(''nndataimport'',''buttoncallback'',gcbf);', ...
    'Position',PointsToPixels*[336 96 25 21], ...
    'String','-->', ...
     'UserData',ud.Handles.InputEdit,...
      'ToolTipStr','Select the input array to be imported.',...
    'Tag','InputButton');
    ud.Handles.OutputText = uicontrol('Parent',fig, ...
     'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[383 67 70 22], ...
    'String','Output Array:', ...
    'Style','text', ...
      'Tag','OutputText');
   ud.Handles.OutputEdit = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','nncontrolutil(''nndataimport'',''editcallback'',gcbf);', ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[383 53 125 20], ...
    'String','', ...
    'Style','edit', ...
     'UserData',EditUd,...
      'ToolTipStr','Output data array to be imported.',...
    'Tag','OutputEdit');
   ud.Handles.OutputButton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'Callback','nncontrolutil(''nndataimport'',''buttoncallback'',gcbf);', ...
    'Position',PointsToPixels*[336 53 25 21], ...
    'String','-->', ...
     'UserData',ud.Handles.OutputEdit,...
      'ToolTipStr','Select the output array to be imported.',...
    'Tag','OutputButton');
   h1 = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'BackgroundColor',StdColor, ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[179 9 339 28], ...
    'Style','frame');
   ud.Handles.HelpButton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'Callback','nncontrolutil(''nndataimport'',''windowstyle'',gcbf,''normal'');nncontrolutil(''nndataimporthelp'',''main'',gcbf);', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[184 13 74 20], ...
    'String','Help', ...
      'ToolTipStr','Call the Import Data help window.',...
    'Tag','HelpButton');
   ud.Handles.CancelButton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'Callback','nncontrolutil(''nndataimport'',''cancel'',gcbf);', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[435 13 74 20], ...
    'String','Cancel', ...
      'ToolTipStr','Discard the import action and close this menu',...
    'Tag','CancelButton');
   ud.Handles.OKButton = uicontrol('Parent',fig, ...
    'Unit',StdUnit, ...
    'Callback','nncontrolutil(''nndataimport'',''apply'',gcbf);', ...
    'ListboxTop',0, ...
    'Position',PointsToPixels*[313 13 74 20], ...
    'String','OK', ...
      'ToolTipStr','Import the data into the Plant Identification window.',...
    'Tag','OKButton');

  end
   set(fig,'UserData',ud,'visible','on','WindowStyle','modal')
   nncontrolutil('nndataimport','structures',gcbf);
   nncontrolutil('nndataimport','workspace',gcbf);
   
elseif strcmp(cmd,'cancel')
   H=get(ud.Handles.parent,'userdata');
   arg1=get(H.gcbh_ptr,'userdata');
   arg2=get(H.gcb_ptr,'userdata');
   if strcmp('ref',ud.Handles.type_net)
      nnmodref('',arg1,arg2,'');
   else
      nnident('',arg1,arg2,'');
   end
   delete(fig)
   return;
   
elseif strcmp(cmd,'windowstyle')
   set(fig,'visible','on','WindowStyle',arg2)
   return;
   
elseif strcmp(cmd,'radiobutton')
   val = get(gcbo,'Value');
   sibs = get(gcbo,'UserData');
   
   if ~val,
      set(gcbo,'Value',1);
   elseif val==1,
      set(sibs,'Value',0);
      set(ud.Handles.FileNameEdit,'String','', ...
         'UserData',struct('FileName',[],'PathName',[]));
      set(ud.Handles.DataEdit,'String','','UserData',...
            struct('ListIndex',0,'String',''));
      set(ud.Handles.InputEdit,'String','','UserData',...
            struct('ListIndex',0,'String',''));
      set(ud.Handles.OutputEdit,'String','','UserData',...
            struct('ListIndex',0,'String',''));
   end % if/else val
   
elseif strcmp(cmd,'radiobutton1')
   val = get(gcbo,'Value');
   sibs = get(gcbo,'UserData');
   
   if ~val,
      set(gcbo,'Value',1);
   elseif val==1,
      set(sibs,'Value',0);
%      set(ud.Handles.DataEdit,'String','','UserData',...
%            struct('ListIndex',0,'String',''));
%      set(ud.Handles.InputEdit,'String','','UserData',...
%            struct('ListIndex',0,'String',''));
%      set(ud.Handles.OutputEdit,'String','','UserData',...
%            struct('ListIndex',0,'String',''));
   end % if/else val
   
elseif strcmp(cmd,'arrays') | strcmp(cmd,'structures'),
   if strcmp(cmd,'arrays')
      set(ud.Handles.InputText,'enable','on');
      set(ud.Handles.InputEdit,'enable','on');
      set(ud.Handles.InputButton,'enable','on');
      set(ud.Handles.OutputText,'enable','on');
      set(ud.Handles.OutputEdit,'enable','on');
      set(ud.Handles.OutputButton,'enable','on');
      set(ud.Handles.DataText,'enable','off');
      set(ud.Handles.DataEdit,'enable','off');
      set(ud.Handles.DataButton,'enable','off');
   else
      set(ud.Handles.InputText,'enable','off');
      set(ud.Handles.InputEdit,'enable','off');
      set(ud.Handles.InputButton,'enable','off');
      set(ud.Handles.OutputText,'enable','off');
      set(ud.Handles.OutputEdit,'enable','off');
      set(ud.Handles.OutputButton,'enable','off');
      set(ud.Handles.DataText,'enable','on');
      set(ud.Handles.DataEdit,'enable','on');
      set(ud.Handles.DataButton,'enable','on');
   end
   if get(ud.Handles.Wbutton,'Value'),
      nncontrolutil('nndataimport','workspace',gcbf);
   else
      nncontrolutil('nndataimport','matfile',gcbf);
   end
   
elseif strcmp(cmd,'editcallback'),
   %---Callback for the Input, Output and Structure Edit boxes
   %---These boxes should contain an index into the List Box string
   %---The Index should be zero when an invalid name is entered
   TryString = get(gcbo,'String');
   udEdit = get(gcbo,'UserData');
   
   if isempty(TryString), % empty value, leave it that way
      udEdit.ListIndex=0;
      udEdit.String='';
   else      
      IndList = strmatch(TryString,ud.ListData.Names,'exact');
      
      if isempty(IndList),
          % Revert to last valid entry
         if isempty(udEdit.ListIndex),
            set(gcbo,'String','');
         else
            set(gcbo,'String',udEdit.String);
         end, %if/else isempty(udEdit)
         WarnStr=['You must enter an array or structure from the list box.'];
         warndlg(WarnStr,'Import Warning','modal');
      else, % Store the list index
         udEdit.ListIndex=IndList;
         udEdit.String=TryString;
      end % if/else isempty(IndList);
   end % if/else isempty(TryString);
   set(gcbo,'UserData',udEdit);
   
elseif strcmp(cmd,'matfile'),
   set(ud.Handles.ModelText,'string','MAT-file Contents');
   set([ud.Handles.FileNameText,...
         ud.Handles.FileNameEdit,...
         ud.Handles.BrowseButton],'enable','on');
   set(ud.Handles.FileNameText,'String','MAT-filename:');
   set(ud.Handles.BrowseButton,'Callback','nncontrolutil(''nndataimport'',''browsemat'',gcbf);');
   set(ud.Handles.FileNameEdit,...
      'Callback','nncontrolutil(''nndataimport'',''clearpath'',gcbf);nncontrolutil(''nndataimport'',''matfile'',gcbf);');
   
   FileName = get(ud.Handles.FileNameEdit,'String');   
   if isempty(FileName),
      Data=struct('Names','','Objects',[]);
   else
      try
         if get(ud.Handles.Abutton,'Value'),
            type_data='double';
         else
            type_data='struct';
         end
         VAR=load(FileName);
         WorkspaceVars=whos('-file',FileName);
         sysvar=cell(size(WorkspaceVars));
         s=0;
         for ct=1:size(WorkspaceVars,1),
            VarClass=WorkspaceVars(ct).class;
            if (strcmp(VarClass,type_data)) & isequal(2,length(WorkspaceVars(ct).size)) %& ~(strcmp(WorkspaceVars(ct).name,'ud')),
               % Only look for structure objects
               s=s+1;
               sysvar(s)={WorkspaceVars(ct).name};
            end % if isa
         end % for ct
         sysvar=sysvar(1:s);
         
         DataObjects = cell(2,1);
         for ctud=1:s,
            DataObjects{ctud} = eval(cat(2,'VAR.',sysvar{ctud}));
         end % for
         Data = struct('Names',{sysvar},'Objects',{DataObjects});
         
      catch
         warndlg(lasterr,'Import Warning','modal'); 
         set(ud.Handles.FileNameEdit,'String','');
         FileName='';
         Data=struct('Names','','Objects',[]);
      end % try/catch
   end % if/else check on FileName
   
   LocalFinishLoad(fig,ud,FileName,Data)
   
elseif strcmp(cmd,'workspace')
   set(ud.Handles.ModelText,'string','Workspace Contents');
   set([ud.Handles.FileNameText,...
         ud.Handles.FileNameEdit,...
         ud.Handles.BrowseButton],'enable','off');
   
   %----Look for all workspace variables of class 'ss', 'tf', or 'zpk'
   WorkspaceVars=evalin('base','whos');
   sysvar=cell(size(WorkspaceVars));
   s=0;
   
   if get(ud.Handles.Abutton,'Value'),
      type_data='double';
   else
      type_data='struct';
   end
   
   for ct=1:size(WorkspaceVars,1),
      VarClass=WorkspaceVars(ct).class;
      if (strcmp(VarClass,type_data))  & isequal(2,length(WorkspaceVars(ct).size)),
         % Only look for Non-array (TF, SS, and ZPK) LTI objects
         s=s+1;
         sysvar(s,1)={WorkspaceVars(ct).name};
      end % if isa
   end % for ct
   sysvar=sysvar(1:s,1);
   
   DataObjects = cell(s,1);
   for ctud=1:s,
      DataObjects{ctud} = evalin('base',sysvar{ctud});
   end
   
   Data = struct('Names',{sysvar},'Objects',{DataObjects});
   
   set(ud.Handles.ModelList,'String',sysvar,'value',1)
   
   %---Update the Import Figure Userdata
   ud.ListData=Data;
   set(fig,'UserData',ud);
      
elseif strcmp(cmd,'browsemat')
   filterspec = '*.mat';
   
   udFileEdit = get(ud.Handles.FileNameEdit,'UserData');
   LastPath = udFileEdit.PathName;
   CurrentPath=pwd;
   if ~isempty(LastPath),
      cd(LastPath);
   end
   [filename,pathname] = uigetfile(filterspec,'Import file:');
   if ~isempty(LastPath),
      cd(CurrentPath);
   end
   
   if filename,
      if ~strcmpi(pathname(1:end-1),CurrentPath)
         ImportStr = [pathname,filename(1:end-4)];
      else
         ImportStr = filename(1:end-4);
      end
      set(ud.Handles.FileNameEdit,'String',ImportStr);
      nncontrolutil('nndataimport','matfile',fig);
      set(ud.Handles.DataEdit,'String','','UserData',...
            struct('ListIndex',0,'String',''));
      set(ud.Handles.InputEdit,'String','','UserData',...
            struct('ListIndex',0,'String',''));
      set(ud.Handles.OutputEdit,'String','','UserData',...
            struct('ListIndex',0,'String',''));
   end
   
elseif strcmp(cmd,'clearpath') & (fig)
   %---Callback for the SImulink File box
   %    Whenever a new name is entered, update the Userdata
   NewName = get(gcbo,'String');
   indDot = findstr(NewName,'.');
   if ~isempty(indDot),
      NewName=NewName(1:indDot(end)-1);
      set(ud.Handles.FileNameEdit,'String',NewName)   
   end
      
elseif strcmp(cmd,'buttoncallback')
   %---Callback for the Arrow Buttons
   EditBox = get(gcbo,'UserData');
   AllNames = get(ud.Handles.ModelList,'String');
   if ~isempty(AllNames), % Make sure these is something in the list
      SelectedName = get(ud.Handles.ModelList,'Value');
      udEdit = get(EditBox ,'UserData');
      udEdit.String = AllNames{SelectedName};
      udEdit.ListIndex = SelectedName;
      set(EditBox,'String',AllNames{SelectedName},'UserData',udEdit);
   end
   
elseif strcmp(cmd,'apply'), % Send the new Feedback structure to the Parent's Userdata
   if get(ud.Handles.Sbutton,'value')
      DataOK=0;
      %---Data
      udDataEdit = get(ud.Handles.DataEdit,'UserData');
      if udDataEdit.ListIndex~=0, 
         ud.ModelData.Data.Name = udDataEdit.String;
         ud.ModelData.Data.Object = ...
           ud.ListData.Objects{udDataEdit.ListIndex};
         
         if ~isfield(ud.ModelData.Data.Object,'U') | ~isfield(ud.ModelData.Data.Object,'Y')
            warndlg('The data structure must at least have fields U and Y for Input and Output arrays.',...
               'Import Warning','modal');
            return
         end
         size_U=size(ud.ModelData.Data.Object.U(:),1);
         size_Y=size(ud.ModelData.Data.Object.Y(:),1);
         if size_U ~= size_Y
            warndlg('The Input and Output arrays (U and Y) inside the data structure must have the same dimensions.',...
               'Import Warning','modal');
            return
         end
         
         if isfield(ud.ModelData.Data.Object,'Ts')
            H=get(ud.Handles.parent,'userdata');
            Ts=str2num(get(H.Sampling_time,'string')); 
            if Ts~=ud.ModelData.Data.Object.Ts
               temp=questdlg({['Your data structure has a different sampling time than the simulink controller block.'] ...
                     ['The simulink controller block will use the sampling time already configured.'] ...
                     ['Do you want to continue ?']},...
                  'Import Warning','Yes','No','No');
               if strcmp(temp,'No')
                  return
               end
            end
         end
         
         ImportStr=get(ud.Handles.FileNameEdit,'String');
         if strcmp(ud.Handles.type_net,'narma_l2') | strcmp(ud.Handles.type_net,'nnpredict') ...
               | strcmp(ud.Handles.type_net,'nnmodref')
            nnident('have_file',ImportStr,ud.ModelData.Data.Name);
         elseif strcmp(ud.Handles.type_net,'ref')
            nnmodref('have_file',ImportStr,ud.ModelData.Data.Name);
         end
         DataOK=1;
      end
               
      figure_variables=get(ud.Handles.parent,'userdata');
      parent_simulink=get(figure_variables.gcbh_ptr,'userdata');
      
      if DataOK
         H=get(ud.Handles.parent,'userdata');
         arg1=get(H.gcbh_ptr,'userdata');
         arg2=get(H.gcb_ptr,'userdata');
         if strcmp('ref',ud.Handles.type_net)
            nnmodref('',arg1,arg2,'');
         else
            nnident('',arg1,arg2,'');
         end
         delete(fig)   
         return
      end
   else
      U_OK=0;
      Y_OK=0;
      %---Data
      udInputEdit = get(ud.Handles.InputEdit,'UserData');
      udOutputEdit = get(ud.Handles.OutputEdit,'UserData');
      if udInputEdit.ListIndex==0 | udOutputEdit.ListIndex==0, 
         warndlg('You must define the input and output variables to be imported.',...
             'Import Warning','modal');
         return
      end
      if udInputEdit.ListIndex~=0 & udOutputEdit.ListIndex~=0, 
         ud.ModelData.DataU.Name = udInputEdit.String;
         ud.ModelData.DataU.Object = ...
           ud.ListData.Objects{udInputEdit.ListIndex};
         ud.ModelData.DataY.Name = udOutputEdit.String;
         ud.ModelData.DataY.Object = ...
           ud.ListData.Objects{udOutputEdit.ListIndex};
         
         size_U=size(ud.ModelData.DataU.Object);
         size_Y=size(ud.ModelData.DataY.Object);
         if (size_U(1)>1 & size_U(2)>1) | (size_Y(1)>1 & size_Y(2)>1)
            warndlg('The Input and Output arrays must be row (1xN) or column (Nx1) variables.',...
               'Import Warning','modal');
            return
         end
         
         size_U=size(ud.ModelData.DataU.Object,1);
         if size_U<=1
            size_U=size(ud.ModelData.DataU.Object,2);
            if size_U<=1
               warndlg('The Input Array must be empty or have only one element.',...
                  'Import Warning','modal');
               return
            end
         end
         size_Y=size(ud.ModelData.DataY.Object,1);
         if size_Y<=1
            size_Y=size(ud.ModelData.DataY.Object,2);
            if size_Y<=1
               warndlg('The Output Array must be empty or have only one element.',...
                  'Import Warning','modal');
               return
            end
         end
         if size_U ~= size_Y
            warndlg('The Input and Output arrays must have the same dimensions.',...
               'Import Warning','modal');
            return
         end
         
         ImportStr=get(ud.Handles.FileNameEdit,'String');
         if strcmp(ud.Handles.type_net,'narma_l2') | strcmp(ud.Handles.type_net,'nnpredict') ...
               | strcmp(ud.Handles.type_net,'nnmodref')
            nnident('have_file',ImportStr,ud.ModelData.DataU.Name,ud.ModelData.DataY.Name);
         elseif strcmp(ud.Handles.type_net,'ref')
            nnmodref('have_file',ImportStr,ud.ModelData.DataU.Name,ud.ModelData.DataY.Name);
         end
         DataOK=1;
      end
               
      figure_variables=get(ud.Handles.parent,'userdata');
      parent_simulink=get(figure_variables.gcbh_ptr,'userdata');
      
      if DataOK
         H=get(ud.Handles.parent,'userdata');
         arg1=get(H.gcbh_ptr,'userdata');
         arg2=get(H.gcb_ptr,'userdata');
         if strcmp('ref',ud.Handles.type_net)
            nnmodref('',arg1,arg2,'');
         else
            nnident('',arg1,arg2,'');
         end
         delete(fig)   
         return
      end
   end
      
   warndlg('You must define the variables to be imported.',...
           'Import Warning','modal');
          
   set(fig,'UserData',ud)

   uiresume(fig)
   
end

%-----------------------------Internal Functions--------------------------
%%%%%%%%%%%%%%%%%%%%%%%
%%% LocalFinishLoad %%%
%%%%%%%%%%%%%%%%%%%%%%%
function LocalFinishLoad(ImportFig,ud,FileName,Data)

%---Update the FileNameEdit Userdata
[P,F]=fileparts(FileName);
udNames = get(ud.Handles.FileNameEdit,'UserData');
udNames.PathName=P; 
udNames.FileName=F;
set(ud.Handles.FileNameEdit,'UserData',udNames)

%---Update the Import Figure Userdata
set(ud.Handles.ModelList,'String',Data.Names,'value',1)
ud.ListData=Data;
set(ImportFig,'UserData',ud);

