
# =================================================
# Modelo de Desicin de Produccin de puertas y ventanas
# =================================================


# --------------------------------------
# Sets
# --------------------------------------

#conjunto de productos
set PROD;  	

#conjunto de recursos
set REC;  	
	

# --------------------------------------
# Parameters
# --------------------------------------

#cantidad de recurso disponible
param crec {REC} >= 0; 
			   
#cantidad necesaria de recurso para cada producto
param uso {PROD, REC} >= 0;
			   
#demanda del producto
param dda {PROD} >= 0;

#costo de produccion
param costo {PROD} >= 0; 

#precio de venta del producto  
param precio {PROD} >= 0;

#beneficio neto por unidad producida;
param ben{j in PROD}:= precio[j]-costo[j];


# --------------------------------------
# Variables
# --------------------------------------
 

#cuanto produzco 
var x {PROD} >= 0;

# --------------------------------------
# Objective
# --------------------------------------

#maximizar utilidades
maximize utilidades: sum {p in PROD} (x[p] * ben[p]);

# --------------------------------------
# Constraints
# --------------------------------------

#satisfacer demanda
subject to satdda {p in PROD}:

			x[p] >=  dda[p];

#restriccion de recursos
subject to recmax{r in REC}:

   	 sum {p in PROD} (x[p]*uso[p,r]) <= crec[r];

    
