% Modelo gravimetrico 2-D

clear all;

g = 0.00667;
rho=input('Densidad (gr/cc) [1] ??');
if(isempty(rho));rho=1; end;

% Definicion de area de trabajo

s0=input('Area de trabajo: x1,y1,x2,y2 (m) [ [0 0 100 10] ] ');
if(isempty(s0));s0=[0 0 100 10]; end;
xlim(1:2) = s0(1:2:3);
ylim(1:2) = s0(2:2:4);

figure;
axis([xlim(1) xlim(2) -ylim(2) -ylim(1)]);
grid on;

% definicion de vertices. Usar boton izquierdo
% hasta finalizar definicion de cuerpo.
% 

nv = 0;
button = 1;
while button == 1,
   nv=nv+1
   [x(nv),y(nv),button]=ginput(1);
   if nv > 1,
      plot(x,y);
      axis([xlim(1) xlim(2) -ylim(2) -ylim(1)]);
      grid on;
   end
end
x(nv) = x(1);
y(nv) = y(1);

plot(x,y);
axis([xlim(1) xlim(2) -ylim(2) -ylim(1)]);
grid on;
xlabel('x (m)','FontSize',12);
ylabel('y (m)','FontSize',12);

npuntos = 100;
xperf   = linspace(xlim(1), xlim(2), npuntos);

for ll=1:npuntos,

      x0  = xperf(ll);
      z0  = 0.0;
      sum = 0;
      x1  =  x(1);
      z1  = -y(1);

      for i=2:nv,
         x2 =  x(i);
         z2 = -y(i);
         [grav] = ribbon_g(x0,z0,x1,z1,x2,z2);
         sum = sum + grav;
         x1  = x2;
         z1  = z2;
      end

      perf(ll)=sum*2*g*rho;

end
   
figure;
subplot(2,1,1), plot(xperf,perf);
xlabel('x (m)','FontSize',12);
ylabel('dg (mgal)','FontSize',12);
grid on;

subplot(2,1,2), plot(x,y,'g-');
axis([xlim(1) xlim(2) -ylim(2) -ylim(1)]);
xlabel('x (m)','FontSize',12);
ylabel('y (m)','FontSize',12);