c	CI41A - HIDRAULICA
c	Prof. Yarko Nio
c	Rgimen Impermanente en tuberas
c	---------------------------------------------------
c	Programa CHARAC1: Calcula variacin de la cota
c	piezomtrica y la velocidad del flujo impermanente
c	en una tubera que descarga desde un estanque de
c	nivel constante, debido al cierre de una vlvula 
c	ubicada en su extremo de aguas abajo.
c	
c	El programa est basado en el mtodo explcito de
c	diferencias finitas.
c	***************************************************
c	Las variables se han adimensionalizado
c	del siguiente modo:
c
c	x = x*/L ; t = t*/(L/a) ; H = H*/H0 ; u = u*/u0
c
c	donde las variables con * son dimensionales.
c
c	L: longitud de la tubera
c	H0: carga inicial
c	u0: velocidad inicial del flujo
c	a: velocidad del sonido
c	x: distancia adimensional medida desde el estanque
c	t: tiempo adimensional medido desde el momento de cierre
c	H: carga adimensional en el punto x y tiempo t
c	u: velocidad adimensional en el punto x y tiempo t
c
c	Otras variables:
c	g: aceleracin de gravedad
c	f: factor de friccin
c	D: dimetro de la tubera
c	theta: ngulo de inclinacin de la tubera
c
c	Variables requeridas por el mtodo numrico:
c	dx: discretizacin adimensional de la distancia
c	dt:	discretizacin adimensional del tiempo
c	nx: nmero de puntos en la discretizacin de x
c	nt: nmero de puntos en la discretizacin de t
c	nr: indica cada cuntas iteraciones de t se escriben
c	    los resultados 
c	Hold: arreglo de valores de H en cada x en el tiempo t - dt
c	Hnew: arreglo de valores de H en cada x en el tiempo t
c	uold: arreglo de valores de u en cada x en el tiempo t - dt
c	unew: arreglo de valores de u en cada x en el tiempo t
c
c	Variables relacionadas con el cierre de la vlvula
c	etaf : % de cierre final
c	Tf : tiempo de cierre final
c	***************************************************
c	Definiciones iniciales
c	---------------------------------------------------
	common a,L,etaf,Tf
	real L,Hold(0:50),Hnew(0:50),uold(0:50),unew(0:50)
	open(5,file = 'charac1.dat')
	open(6,file = 'charac1.res')
c	***************************************************
c	Lectura de datos:
c	Las variables H0,L,u0,a,D,Tf deben estar en MKS
c	La variable theta debe estar en radianes
c	El resto de las variables son adimensionales
c	---------------------------------------------------
	read(5,*) H0,L,u0,a,f,D,theta
	read(5,*) nt,nr,dx,dt
	read(5,*) etaf,Tf
	nx = 1./dx
	g = 9.8
c	***************************************************
c	Definicin de constantes
c	---------------------------------------------------
	aa = a*u0/g/H0
	bb = u0*L/a/H0*sin(theta)
	cc = f*L/D*u0**2/2/g/H0
c	***************************************************
c	Clculo de H y u en funcion de t y x
c	***************************************************	
c	Inicializa los valores de H y u  
c	---------------------------------------------------
	do j=0,nx
	  Hold(j) = 1.
	  uold(j) = 1.
	enddo
c	---------------------------------------------------
c	Iteracin en el tiempo
c	---------------------------------------------------
	do i=1,nt
c	***************************************************
	t = real(i)*dt
c	---------------------------------------------------
c	Calcula los valores de H y u en el tiempo t conocidos
c	los valores en el tiempo t - dt.
c	---------------------------------------------------
	do j=1,nx-1
c	---------------------------------------------------	
	  Hnew(j) = 0.5*(Hold(j-1) + Hold(j+1) +
	1            aa*(uold(j-1) - uold(j+1)) -
	2         bb*dt*(uold(j-1) + uold(j+1)) -
	3         cc*dt*(abs(uold(j-1))*uold(j-1) -
	4                abs(uold(j+1))*uold(j+1)))
	
	  unew(j) =  0.5/aa*(Hold(j-1) - Hold(j+1) + 
	1                aa*(uold(j-1) + uold(j+1)) -
	2             bb*dt*(uold(j-1) - uold(j+1)) -
	3             cc*dt*(abs(uold(j-1))*uold(j-1) +
	4                    abs(uold(j+1))*uold(j+1)))
c	---------------------------------------------------
	enddo
c	---------------------------------------------------
c	Condicin de borde de aguas arriba
c	(estanque de carga constante)
c	---------------------------------------------------
	Hnew(0) = 1.
	unew(0) = uold(1) + 1./aa*(1. - Hold(1) + bb*dt*
	1         uold(1) - cc*dt*abs(uold(1))*uold(1))
c	---------------------------------------------------
c	Condicin de borde de aguas abajo
c	(cierre de vlvula segn ley de cierre especificada
c	en subrutina "cierre").
c	---------------------------------------------------
	call cierre(t,eta)
	dd = -(Hold(nx-1) + (aa - bb*dt - cc*dt*
	1                   abs(uold(nx-1)))*uold(nx-1))
	unew(nx) = -0.5*aa*eta**2 + sqrt((0.5*aa*
	1                           eta**2)**2 - dd*eta**2)
	if(eta.eq.0.) then
	  Hnew(nx) = -dd
	else
	  Hnew(nx) = (unew(nx)/eta)**2
	endif
c	---------------------------------------------------
c	Escribe resultados del clculo: H(x) y u(x) cada "nr"
c	iteraciones de tiempo
c	---------------------------------------------------
	if(mod(i,nr).eq.0) then
	  write(6,10) t,eta
 10	  format(/,'Resultados en el tiempo: t = ',f6.2,/,
	1          'eta = ',f6.2,/,3x,'x',11x,'H',11x,'u')
	  do j=0,nx
	    x = real(j)*dx
	    write(6,20) x,char(9),Hnew(j),char(9),unew(j)
 20	    format(f6.2,2(a1,f10.3))
	  enddo
	endif	
c	---------------------------------------------------
c	Resetea los valores antiguos de H y u  
c	---------------------------------------------------
	do j=0,nx
	  Hold(j) = Hnew(j)
	  uold(j) = unew(j)
	enddo
c	***************************************************
	enddo
c	***************************************************
	stop
	end
	
	subroutine cierre(t,eta)
c	***************************************************
c	Calcula el valor de la abertura adimensional de la
c	vlvula segn un cierre lineal
c	***************************************************
	common a,L,etaf,Tf
	real L
c	---------------------------------------------------
	Tfad = Tf*a/L
	if(t.gt.Tfad) then
	  eta = etaf
	else
	  eta = 1. - (1. - etaf)*t/Tfad
	endif
c	***************************************************
	return
	end