/* Version 1.0 */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <fcntl.h>

#define BUFMAX 512
#define TESTBAD 0
#define TESTOK 	1

char file [BUFMAX]= "/dev/nDev";

/* El contenido y numero de llaves puede variar al momento de corregir */
char key1[64]="key1"; char value1[BUFMAX-64]="if music be the food of love,\0";
char key2[64]="key2"; char value2[BUFMAX-64]="play on; Give me excess of it,\0";
char key3[64]="key3"; char value3[BUFMAX-64]="that, surfeting, The appetite may\0";
char key4[64]="key4"; char value4[BUFMAX-64]="sicken, and so die\0";

void nDevWrite(char *key, char *value){
	char buf[BUFMAX];
	int fp,n;
	
	if((fp=open(file, O_WRONLY))<0){
		printf("Error no puedo abrir %s para escritura.\n", file);
		exit(1);
	}

	/* Concatenamos, "key:value" */
	memset(buf, '\0', BUFMAX);
	strcat(buf, key); strcat(buf, ":");strcat(buf, value);
	n=strlen(buf); 
	
	if(write(fp, buf, n)!=n	){
		printf("Error en write\n");
		exit(1);
	}
	
	close(fp);
	printf("Guardado, %s total=%d\n",buf,n);
}

int nDevRead(char *dest, char *key){
	int total=0;
	int fp,n;

	/* Truco, pasamos el word que nos interesa en el read*/
	memset(dest, '\0', BUFMAX);
	strcpy(dest, key);

	if( (fp= open(file,O_RDONLY))<0){
		printf("Error no puedo abrir %s para lectura.\n", file);
		exit(1);
	}
	while((n=read(fp, dest, BUFMAX))>0)
		total+=n;
	
	if(close(fp)<0){
		printf("Error en close %s para lectura.\n",file);
		exit(1);
	}

	return total;
}

/* Padre lee del hijo. */
int LectorCode(char *key, char *value){
	int msg_length,status;	
	char buf[BUFMAX];

	wait(&status); /* Esperamos que el hijo escriba */

	if(WIFEXITED(status) && WEXITSTATUS(status)){
		printf("Error en status de hijo\n");
		exit(1);
	}

	msg_length = nDevRead(buf, key);
	
	printf("Leido, key:%s buf:%s total=%d\n", key, buf,msg_length);
	if(strcasecmp(value, buf)==0){
		return TESTOK;
	}
	return TESTBAD;
}

void TestI(){

	pid_t hijo;

	printf("Escritura y lectura de un registro.\n");
	
	if((hijo=fork())<0){
		printf("Error cant fork\n");
		exit(1);
	}

	if(hijo==0){
		nDevWrite(key1, value1);
		exit(0);
	}
	else{
		if(LectorCode(key1, value1)==TESTBAD){
			printf("Error, escrito distinto de leido.\n");
			exit(1);
		}
		exit(0);
	}

}

void TestII(){
	
	pid_t hijo;
	
	printf("Soportar mas de un registro.\n"); fflush(stdout);
	
	if((hijo=fork())<0){
		printf("Error cant fork\n");
		exit(1);
	}

	if(hijo==0){
		nDevWrite(key2, value2);
		exit(0);
	}
	else{
		if(LectorCode(key2, value2)==TESTBAD){
			printf("Error, escrito distinto de leido.\n");
			exit(1);
		}
		if(LectorCode(key1, value1)==TESTBAD){
			printf("Error, en segunda lectura.\n");
			exit(1);
		}
		exit(0);
	}

}

void TestIII(){
	pid_t hijo;

	printf("Reescritura de registro.\n");
	
	if((hijo=fork())<0){
		printf("Error can't fork\n");
		exit(1);
	}

	if(hijo==0){
		nDevWrite(key1, value3);
		exit(0);
	}
	else{
		if(LectorCode(key1, value3)==TESTBAD){
			printf("Error,  reescrito distinto de leido.\n");
			exit(1);
		}
//		nDevWrite(key1, value1);
		exit(0);
	}
}

void TestIV(){
	pid_t hijo;
	printf("Borrado de registro.\n");

	if((hijo=fork())<0){
		printf("Error can't fork\n");
		exit(1);
	}

	if(hijo==0){
		nDevWrite(key1, "");
		exit(0);
	}
	else{
		if(LectorCode(key1, "")==TESTBAD){
			printf("Error,  rescrito distinto de leido.\n");
			exit(1);
		}
		exit(0);
	}
}


void TestV(){
	pid_t hijo;

	printf("Escritura de registros por /dev/nDevX distintos.\n");
	
	if((hijo=fork())<0){
		printf("Error cant fork\n");
		exit(1);
	}

	if(hijo==0){
		strcpy(file, "/dev/nDev2");
		nDevWrite(key1, value3);
		strcpy(file, "/dev/nDev3");
		nDevWrite(key1, value4);
		exit(0);
	}
	else{
		strcpy(file, "/dev/nDev3");
		if(LectorCode(key1, value4)==TESTBAD){
			printf("Error, /dev/nDev3 escrito distinto de leido.\n");
			exit(1);
		}
		strcpy(file, "/dev/nDev2");
		if(LectorCode(key1, value3)==TESTBAD){
			printf("Error, /dev/nDev2 escrito distinto de leido.\n");
			exit(1);
		}
		exit(0);
	}
	
}

int TestExec(void (*Test)()) {
	pid_t hijo;
	int status;

	if( (hijo=fork())<0){
		printf("Error can't fork Test()");	
		exit(1);
	}
	
	if( hijo==0){
		(*Test)();		
	}
	else{
		wait(&status);

		if(WIFEXITED(status) && WEXITSTATUS(status)){
			return TESTBAD;
		}
		return TESTOK;
	}

}

main(int argc, char *argv[]){

	int i,total=0, numtest=5;
	void *Test[]={(void *)TestI, (void *)TestII, (void *)TestIII , 
			(void *)TestIV, (void *)TestV };
	int nota[]={1, 1, 1, 1, 1, 1};

	for(i=0;i<numtest;i++){
		printf("Test %d. " , i+1);fflush(stdout);
		if(TestExec(Test[i])==TESTOK){
			printf("Test %d. Aprobado +%d.0\n\n",i+1,nota[i]);
			total+=nota[i];
		}
		else
			printf("Test %d. Error\n\n",i+1);
	}

	printf("\nNumero test aprobados: %d / %d \n",total, numtest);

	if(total==numtest)
		printf("Nota: 7.0\n\n");
	else
		printf("Nota: 1.0\n\n");

	printf("*** Verificando Used by !=0 ***\n");
	system("lsmod | grep Module");
	system("lsmod | grep nDev");
	
	
	printf("\nAdvertencia: Si el modulo nDev tiene un 'Used by' !=0\n"); 
	printf("despues de los test la nota final no es valida.\n\n");

}


