/* Version 1.0 */

#include <string.h>
#include <fcntl.h>

#define BUFMAX 512

char file[BUFMAX]="/dev/nDev";

void nDevWrite(char *key, char *value){
	char buf[BUFMAX];
	int fp,n;
	
	if((fp=open(file, O_WRONLY))<0){
		printf("Error no puedo abrir %s para escritura.\n", file);
		exit(1);
	}

	/* Concatenamos, "key:value" */
	memset(buf, '\0', BUFMAX);
	strcat(buf, key); strcat(buf, ":");strcat(buf, value);
	n=strlen(buf); 
	if(write(fp, buf, n)!=n	){
		printf("Error en write\n");
		exit(1);
	}
	
	close(fp);
	printf("Guardado, %s total=%d\n",buf,n);
}

int nDevRead(char *key){
	char dest[BUFMAX];
	int total=0;
	int fp,n;

	/* Truco, pasamos el word que nos interesa en el read*/
	memset(dest, '\0', BUFMAX);
	strcpy(dest, key);

	if( (fp= open(file,O_RDONLY))<0){
		printf("Error no puedo abrir %s para lectura.\n", file);
		exit(1);
	}
	while((n=read(fp, dest, BUFMAX))>0)
		total+=n;
	
	if(close(fp)<0){
		printf("Error en close %s para lectura.\n",file);
		exit(1);
	}

	printf("%s\n",dest);
	return total;
}

void usage(){
	printf("use: ndevclient -w key value\n");
	printf("     ndevclient -r key\n\n");
	printf("     ndevclient -d key\n\n");
	printf("     max key length:    63 (64-1)\n");
	printf("     max value length: 447 (512-64-1)\n");

	exit(1);
}

int main(int argc, char *argv[]){
	int optchar;

	while ((optchar = getopt (argc, argv, "rwd")) != -1){
		switch (optchar){
			case 'r':
				if(argc != 3 || strlen(argv[2]) >  63) usage();
				nDevRead(argv[2]);
				exit(0);
			case 'w':
				if(argc != 4 || strlen(argv[2]) > 63 || 
								strlen(argv[3]) > 512-63-1) usage();
				nDevWrite(argv[2], argv[3]);
				exit(0);
			case 'd':
				if(argc != 3 || strlen(argv[2]) >  63) usage();
				nDevWrite(argv[2], "\0");
				exit(0);
			default:
				usage();
		}
	}

	usage();
}
