#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <wait.h>
#include "tarea.h"
#include "modelo.h"

	/* globales */
servicio *gListaServicios;
puerto *gListaPuertos;
int gSTDOUT;
int gSTDERR;
	/* tarea 3 */
proceso *gColaRequerimientos;
int gDone;
int gTieneCambios;
int f_inetd;
int f_services;
char *inetd_name;

#define new_proceso(p,s,in) \
	p = (proceso *) calloc (1, sizeof (proceso));\
	p->servicio = s;\
	p->in = strdup(in)

	/* funcion generica para liberar listas */
void free_list (lista *l, int t)
{
	DPRINTF ("liberando lista (%ld)\n", (unsigned long)l);
	if (!l) return;
	free_list (l->sgte, t);
	if (!t)
		free (((puerto *)t)->servicio);
	else {
		free (((servicio *)t)->name);
		free (((servicio *)t)->comando);
		free (((servicio *)t)->argumentos);
	}
	free (l);
}

void add_port (char *serv, int portNumber, servicio_protocol proto)
{
	puerto *p = gListaPuertos;
	if (gListaPuertos == NULL) {
		gListaPuertos = (puerto *) calloc (1, sizeof (puerto));
		p = gListaPuertos;
	} else {
		while (p->sgte != NULL)
			p = p->sgte;
		p->sgte = (puerto *) calloc (1, sizeof(puerto));
		p = p->sgte;
	}
	p->sgte = NULL;
	p->servicio = (char *) malloc (strlen(serv));
	strncpy (p->servicio, serv, strlen(serv));
	p->puerto = portNumber;
	p->protocolo = proto;
}

int find_port (char *servicio)
{
	puerto *p = gListaPuertos;
	while (p != NULL) {
		if (!strcmp (servicio, p->servicio))
			return p->puerto;
		p = p->sgte;
	}
	return -1;
}

void add_service (char *t1,char *t2,char *t3,char *t4,
	char *t5,char *t6,char *t7)
{
	int portNumber;
	servicio *s = gListaServicios;

	portNumber = find_port (t1);
	if (portNumber < 1) {
		inetd_err (t1);
		return;
	}

	if (gListaServicios == NULL) {
		gListaServicios = (servicio *) calloc (1, sizeof (servicio));
		s = gListaServicios;
	} else {
		while (s->sgte != NULL)
			s = s->sgte;
		s->sgte = (servicio *) calloc (1, sizeof (servicio));
		s = s->sgte;
	}
	s->sgte = NULL;
	s->name = (char *) malloc (strlen(t1));
	strncpy (s->name, t1, strlen(t1));
	s->puerto = portNumber;
	s->socket = (!strcmp(t2,"stream")) ? kSocketStream : kSocketDgram;
	s->protocolo = (!strcmp(t3,"tcp")) ? kProtocolTCP : kProtocolUDP;
	s->concurrencia = (!strcmp(t4,"wait")) ? kConcurrenciaWait : kConcurrenciaNoWait;
	strncpy (s->userid, t5, strlen(t5));
	s->comando = (char *) malloc (strlen(t6));
	strncpy (s->comando, t6, strlen(t6));
	if (strlen (t7) > 0) {
		s->argumentos = (char *) malloc (strlen(t7));
		strncpy (s->argumentos, t7, strlen(t7));
	}
}

void inetd_err (char *str)
{
	i_error (errorServicioNoValido, str);
}

void load_services ()
{
	char *linea;
	char serv[70];
	char proto[3];
	int portNumber, pp;
	/*
	 * :-P 
	 * ver parse_add para ver como se tiene que hacer realmente
	 */
	char t1[40], t2[40], t3[40], t4[40], t5[40], t6[40], t7[40];

	/* cargar los puertos */
	free_list ((lista *)gListaPuertos, 0);
	linea = NULL;
	DPRINTF ("leyendo %d\n", f_services);
	while (lee_linea (f_services, &linea) >= 0)  {
		if (linea[0] == '#' || linea[0] == 0) continue;
		sscanf (linea, "%s %d/%s", serv, &portNumber, proto);
		pp = (!strcmp(proto,"tcp")) ? kProtocolTCP : kProtocolUDP;
		add_port (serv, portNumber, pp);
		freeStr (linea);
	}
	freeStr (linea);
	DPRINTF ("terminamos de leer %d\n", f_services);
	/* cargar servicios */
	DPRINTF ("leyendo %d\n", f_inetd);
	free_list ((lista*)gListaServicios, 1);
	while (lee_linea (f_inetd, &linea) >= 0) {
		if (linea[0] == '#' || linea[0] == 0) continue;
		t7[0] = 0;
		sscanf (linea, "%s %s %s %s %s %s %[^\n]s", t1, t2, t3, t4, t5, t6, t7);
		add_service (t1, t2, t3, t4, t5, t6, t7);
		freeStr (linea);
	}
}

int lee_linea (int fd, char **buf)
{
	char *q, c;
	int n=BUFS, i, l;

	if (*buf) free (*buf);
	*buf = (char *) calloc (n, SZC);
	q = *buf;
	for (i=0; i < n; i++)
		if ((l = read (fd, &c, SZC)) == SZC) {
			if (c == '\n') break;
			if (i == n) {
				n *= 2;
				*buf = realloc (*buf, n * SZC);
			}
			*q++ = c;
		} else if (l <= 0)
			break;
	*q = '\0';
	if (l < SZC) return -1;
	return i;
}

void muestra_servicios ()
{
	servicio *s = gListaServicios;
	while (s) {
		printf (formato_salida, s->name,
				(s->socket == kSocketStream) ? "stream" : "dgram",
				(s->protocolo == kProtocolTCP) ? "tcp" : "udp",
				(s->concurrencia == kConcurrenciaWait) ? "wait" : "nowait",
				s->userid,
				s->comando
				);
		s = s->sgte;
	}
}

void elimina_servicio (char *buf)
{
	servicio *s = gListaServicios;
	servicio *q;

	if (!s) return;
		/* caso especial */
	if (!strcmp (s->name, buf)) {
		free (s->name);
		if (s->comando) free (s->comando);
		if (s->argumentos) free (s->argumentos);
		gListaServicios = s->sgte;
		free (s);
		gTieneCambios = 1;
	} else
		while (s && s->sgte) {
			if (!strcmp(s->sgte->name, buf)) {
				free (s->sgte->name);
				if (s->sgte->comando) free (s->sgte->comando);
				if (s->sgte->argumentos) free (s->sgte->argumentos);
				q = s->sgte;
				s->sgte = s->sgte->sgte;
				free (q);
				gTieneCambios = 1;
				break;
			}
			s = s->sgte;
		}
}

void edita_servicio (char *buf, char *buf2, char *buf3)
{
	servicio *s = gListaServicios;

	while (s) {
		if (!strcmp (s->name, buf)) {
			/* ver que hay que editar */
			if (!strcmp (cmd_EDIT_NOMBRE, buf2)) {
				free (s->name);
				s->name = (char *) malloc (strlen(buf3));
				strncpy (s->name, buf3, strlen(buf3));
			} else if (!strcmp (cmd_EDIT_SOCKET, buf2)) {
				if (!strcmp (buf3, "stream"))
					s->socket = kSocketStream;
				else if (!strcmp (buf3, "dgram"))
					s->socket = kSocketDgram;
				else /* error */
					i_error (errorUndef, buf3);
			} else if (!strcmp (cmd_EDIT_PROTOCOLO, buf2)) {
				if (!strcmp (buf3, "tcp"))
					s->protocolo = kProtocolTCP;
				else if (!strcmp (buf3, "udp"))
					s->protocolo = kProtocolUDP;
				else /* error */
					i_error (errorUndef, buf3);
			} else if (!strcmp (cmd_EDIT_CONCURRENCIA, buf2)) {
				if (!strcmp (buf3, "wait"))
					s->concurrencia = kConcurrenciaWait;
				else if (!strcmp (buf3, "nowait"))
					s->concurrencia = kConcurrenciaNoWait;
				else
					i_error (errorUndef, buf3);
			} else if (!strcmp (cmd_EDIT_USERID, buf2)) {
					/* copiar solo 8 caracteres */
				strncpy (s->userid, buf3, 8);
			} else if (!strcmp (cmd_EDIT_COMANDO, buf2)) {
				if (s->comando) free (s->comando);
				s->comando = (char *) malloc (strlen(buf3));
				strncpy (s->comando, buf3, strlen(buf3));
			} else if (!strcmp (cmd_EDIT_ARGS, buf2)) {
				if (s->argumentos) free (s->argumentos);
				s->argumentos = (char *) malloc (strlen(buf3));
				strncpy (s->argumentos, buf3, strlen(buf3));
			} else {
				i_error (errorUndef, buf2);
			}
				/* no siempre es verdad... pero filo */
			gTieneCambios = 1;
			return;
		}
		s = s->sgte;
	}
	i_error (errorServicioNoValido, buf);
}

void edit_parse (char *l, char *q1, char *q2, char *q3)
{
	char *curr = q1;
	for (l = l+5; *l != '\0'; l++) {
		if (*l == ' ') { *curr = '\0'; curr = q2; }
		else if (*l == '=') { *curr = '\0'; curr = q3; }
		else *curr++ = *l;
	}
	*curr = '\0';
}

void parse_add (char *l)
{
	char *args[7], *q;
	int i, len;
	len = strlen (l);
	for (i=0; i < 7; i++)
		args[i] = (char *) calloc (len, SZC);
	q = args[0];
	i = 0;
	while (*l) {
		if (*l == ' ') {
			*q = '\0'; q = args[++i]; l++;
		}
		else *q++ = *l++;
	}
	if (i < 5)
		i_error (errorUndef, "Faltaron Argumentos");
	else {
		if (i == 5) strncpy (args[6], "", 1);
		add_service (args[0], args[1], args[2], args[3], args[4], args[5],
				args[6]);
		gTieneCambios = 1;
	}
	for (i=0; i < 7; i++)
		if (args[i]) free (args[i]);
}

void guarda_cambios ()
{
	servicio *s = gListaServicios;
	FILE *f;
		/*
		 * como tenemos format_salida_arch, usamos fprintf
		 */
	close (f_inetd);
	f = fopen (inetd_name, "w");
	if (!f) {
		i_error (errorAbrirArchivo, "creando inetd_conf");
		return;
	}
	fprintf (f, "## generado por inetd ##\n");
	while (s) {
		fprintf (f,formato_salida_arch, s->name,
				(s->socket == kSocketStream) ? "stream" : "dgram",
				(s->protocolo == kProtocolTCP) ? "tcp" : "udp",
				(s->concurrencia == kConcurrenciaWait) ? "wait" : "nowait",
				s->userid,
				s->comando,
				s->argumentos
				);
		s = s->sgte;
	}
	fprintf (f, "## EOF ##\n");
	fclose (f);
}

int procesa_linea (char *l)
{
	char buf[70], buf2[70], buf3[70];
	if (!strcmp (l, cmd_SHOW)) {
		muestra_servicios ();
	} else if (!strcmp (l, cmd_QUIT)) {
		if (gTieneCambios)
			guarda_cambios ();
		return kExitErr;
	} else if (!strncmp (l, cmd_REMV, strlen(cmd_REMV))) {
		sscanf (l, "remove %s", buf);
		elimina_servicio (buf);
	} else if (!strncmp (l, cmd_EDIT, strlen(cmd_EDIT))) {
		edit_parse (l, buf, buf2, buf3);
		edita_servicio (buf, buf2, buf3);
	} else if (!strncmp (l, cmd_ADD, strlen(cmd_ADD))) {
		parse_add (l+4);
	} else if (l[0] == '\0') {
		return kNoErr;
	} else {
		return kUnknownErr;
	}
	return kNoErr;
}

servicio *busca_servicio (int port)
{
	servicio *p = gListaServicios;
	while (p) {
		if (p->puerto == port) return p;
		p = p->sgte;
	}
	return NULL;
}

void revisa_cola ()
{
	proceso *p = gColaRequerimientos;
	while (p) {
		if (p->pid == 0)
			p->pid = crea_proceso (p->servicio, p->in);
		p = p->sgte;
	}
}

void agregar_a_cola (servicio *s, int wait, char *in) {
	proceso *w = gColaRequerimientos;
	/* buscar cola para ese servicio */
	if (!w) {
		new_proceso (gColaRequerimientos, s, in);
	} else {
		int done = 0;
		while (w->sgte) {
			if (wait && !strcmp (w->servicio->name, s->name)) {
				while (w->cola) w = w->cola;
				new_proceso (w->cola, s, in);
				done = 1;
				break;
			}
			w = w->sgte;
		}
		if (!done) {
			new_proceso (w->sgte, s, in);
		}
	}
	revisa_cola ();
}

int crea_proceso (servicio *s, char *in)
{
	int pid;

	if (!(pid = fork())) {
		int fdin, k, t;
		char *args[6]; /* no es la mejor forma! */
		char *q, *w;
		pid = getpid ();
		fdin = open (in, O_RDONLY);
		close (0); dup (fdin);
		close (1); dup (gSTDOUT);
		close (2); dup (gSTDERR);
		/* crear lista de argumentos */
		if (s->argumentos) {
			q = (char *) malloc (strlen(s->argumentos));
			strcpy (q, s->argumentos);
			w = strtok(q, " ");
			for (k=1; w != NULL; w = strtok (NULL, " "))
				args[k++] = w;
			args[k] = NULL;
		} else
			args[1] = NULL;
		args[0] = (char *) malloc (strlen(s->name));
		strcpy (args[0], s->name);
		t = sleep(5);
		printf ("---- %s %d %d ----\n", s->name, s->puerto, pid);
		fprintf (stderr, "---- %s %d %d ----\n", s->name, s->puerto, pid);
		fflush (stdout);
		fflush (stderr);
		close (fdin);
		close (gSTDOUT);
		close (gSTDERR);
		execv (s->comando, args);
		fprintf (stderr, "%d: FALLO EXECV\n", pid);
		exit (0);
	}
	return pid;
}

void procesa_muerte (int s)
{
	int pid = waitpid (-1, 0, WNOHANG);
	int pp  = 0;
	if (pid > 0) {
		proceso *p = gColaRequerimientos;
		if (p->pid == pid) {
			if (p->cola) {
				gColaRequerimientos = p->cola;
				gColaRequerimientos->sgte = p->sgte;
			} else gColaRequerimientos = p->sgte;
			pp = 1;
			unlink (p->in);
			free (p->in);
			free (p);
		} else {
			while (p->sgte) {
				if (p->sgte->pid == pid) {
					proceso *q = p->sgte;
					pp = 1;
					if (q->cola) {
						p->sgte = q->cola;
						p->sgte->sgte = q->sgte;
					} else p->sgte = q->sgte;
					unlink (q->in);
					free (q->in);
					free (q);
					break;
				}
				p = p->sgte;
			}
		}
		revisa_cola ();
	}
}

void procesa_requerimientos ()
{
	int in = open ("inetd.in", O_RDONLY);
	if (in < 0) return;
	while (1) {
		char temp[50];
		char *linea;
		int puerto, nlin;
		int tmpin, i, leido;
		servicio *serv;
		linea = NULL;
		lee_linea (in, &linea);
		sscanf (linea, "%d %d", &puerto, &nlin);
		if (puerto == 0 && nlin == 0) break;
		serv = busca_servicio (puerto);
		if (!serv) continue;
		sprintf (temp, "/tmp/rabarca/%s.XXXXXX", serv->name);
		tmpin = mkstemp (temp);
		free (linea);
		for (i=0; i < nlin; i++) {
			linea = NULL;
			leido = lee_linea (in, &linea);
			write (tmpin, linea, leido);
			write (tmpin, "\n", 1);
			free (linea);
		}
		close (tmpin);
		agregar_a_cola (serv, (serv->concurrencia == kConcurrenciaWait), temp);
	}
}

int main (int argc, char *argv[])
{
	char *linea, *usuario;
	int err;

	if (argc == 3) {
		f_services = open (argv[2], O_RDWR);
		if (f_services == -1) {
			i_error (errorAbrirArchivo, "No se pudo abrir services");
			return errorAbrirArchivo;
		}
	} else if (argc == 2) {
		f_services = open ("/etc/services", O_RDONLY);
		if (f_services == -1) {
			i_error (errorAbrirArchivo, "No se pudo abrir /etc/services");
			return errorAbrirArchivo;
		}
	} else {
		printf ("uso: %s <inetd.conf> [services]\n", argv[0]);
		return errorUndef;
	}
	f_inetd = open (argv[1], O_RDONLY);
	if (f_inetd == -1) {
		i_error (errorAbrirArchivo, "No se pudo abrir inetd.conf");
		close (f_services);
		return errorAbrirArchivo;
	}
	inetd_name = argv[1];

	gDone = gTieneCambios = 0;
	gListaServicios = NULL;
	gListaPuertos = NULL;
	usuario = getenv ("USER");
	load_services ();
		/* tarea 3 */
	gSTDOUT = open ("inetd.out", O_WRONLY|O_APPEND|O_CREAT, 0644);
	gSTDERR = open ("inetd.err", O_WRONLY|O_APPEND|O_CREAT, 0644);
	signal (SIGCHLD, procesa_muerte);
	procesa_requerimientos ();
		/* ciclo principal */
	DPRINTF ("entrando a ciclo principal (%d)\n", 0);
	linea = NULL;
	while (!gDone) {
		printf (formato_prompt, usuario); fflush (stdout);
		lee_linea (0, &linea);
		err = procesa_linea (linea);
		if (err != kNoErr)
			switch (err) {
			case kArgumentoErr:
				i_error (errorUndef, "Numero incorrecto de argumentos");
				break;
			case kUnknownErr:
				i_error (errorUndef, "Comando no reconocido");
				break;
			case kExitErr:
				gDone = 1;
				break;
			}
	}
	close (gSTDOUT);
	close (gSTDERR);
	return 0;
}

