#ifndef __MODELO_HEADER__
#define __MODELO_HEADER__

#define DEBUG 0
#if DEBUG
#define DPRINTF(x,y) fprintf (stderr, "[D] "x, y);
#else
#define DPRINTF(x,y)
#endif

#define i_error(x,y) fprintf (stderr, formato_error, x, y)
#define freeStr(x) { free(x); x = NULL; }

#define BUFS 1024
#define SZC sizeof(char)

typedef enum { kSocketStream, kSocketDgram } servicio_socket;
typedef enum { kProtocolTCP, kProtocolUDP, kProtocolTCP_UDP } servicio_protocol;
typedef enum { kConcurrenciaWait, kConcurrenciaNoWait } servicio_concurrencia;

typedef struct _servicio {
	struct _servicio *sgte;
	char *name;
	int puerto;
	servicio_socket socket;
	servicio_protocol protocolo;
	servicio_concurrencia concurrencia;
	char userid[9];
	char *comando;
	char *argumentos;
} servicio;

typedef struct _puerto {
	struct _puerto *sgte;
	char *servicio;
	int puerto;
	servicio_protocol protocolo;
} puerto;

typedef struct _lista {
	struct _lista *sgte;
} lista;

/* tarea 3 */
typedef struct _proceso {
	struct _proceso *sgte;
	struct _proceso *cola;
	servicio *servicio;
	char *in;
	int pid;
} proceso;

enum { kNoErr, kArgumentoErr, kUnknownErr, kExitErr };

/* funciones */
void free_list (lista *l, int t);
void load_services ();
int lee_linea (int fd, char **buf);
int  procesa_linea (char *l);
void add_port (char *serv, int portNumber, servicio_protocol proto);
void add_service (char *,char *,char *,char *,char *,char *,char *);
void inetd_err (char *linea);
int find_port (char *servicio);
void elimina_servicio (char *buf);
void edita_servicio (char *buf, char *buf2, char *buf3);
/* tarea 3 */
servicio *busca_servicio (int port);
void procesa_requerimientos ();
void agregar_a_cola (servicio *s, int isWait, char *in);
int crea_proceso (servicio *s, char *in);
void procesa_muerte (int s);
void revisa_cola ();

#endif

