#include <termios.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>

/* retorna nmero de caracteres ledos, o -1 si hubo error */
int getpw(char *buf, unsigned size) {
  struct termios attr;
  int n;

  printf("Password: ");
  fflush(stdout);

  /* obtener los atributos del terminal */
  if(tcgetattr(STDIN_FILENO, &attr)!=0)
    return -1;
  /* apagar eco */
  attr.c_lflag &= ~ECHO;
  /* asignar los atributos al terminal */
  if(tcsetattr(STDIN_FILENO, TCSAFLUSH, &attr)!=0)
    return -1;

  /* leer entrada */
  n=read(STDIN_FILENO, buf, size);
  buf[n-1]='\0';

  /* encender eco */
  attr.c_lflag |= ECHO;
  /* asignar los atributos al terminal */
  if(tcsetattr(STDIN_FILENO, TCSANOW, &attr)!=0)
    return -1;

  return n;
}

#define MAXPW 100
int main() {
  char pw[MAXPW+1];

/*  sleep(5); */
  if(getpw(pw, MAXPW)>=0)
    printf("\n\tpassword=%s\n", pw);

  return 0;
}
