#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>


void error(char *fmt, ...) {
  va_list args;

  va_start(args, fmt);
  fprintf(stderr, "Error: ");
  vfprintf(stderr, fmt, args);
  fprintf(stderr, "\n");
  va_end(args);

  exit(1);
}


int main()
  {
    int fd[2];
    int pid;
    FILE *out;
    int status;
    int i;
    
    if(pipe(fd)!=0)
        error("Can't create pipe");
    if((pid=fork())==-1)
        error("Can't fork");
    
    if(pid==0) /* es el hijo */
      {
        /* el siguiente truco pone al extremo del lectura del pipe
           como el stdin del nuevo proceso */
        close(STDIN_FILENO);
        dup(fd[0]); /* aprovechamos que se usa el mismo fd recin liberado */
        close(fd[0]);
        close(fd[1]);
    
        execlp("more", "more", NULL);
        /* no retorna */
      }
    
    /* este es el padre */
    close(fd[0]); /* no va a leer del pipe */
    
    out=fdopen(fd[1], "w"); /* simula que el extremo de lectura del pipe
                               fue abierto con fopen */
    /* ahora generamos el output */
    
    for(i=1; i<=200; ++i)
        fprintf(out, "Lnea nmero %d\n", i);
    
    fclose(out);
    
    (void)wait(&status); /* esperamos que el hijo muera */
    printf("hola\n");

    return 0;
  }
