/* Leer una lnea del teclado dndole 10 segundos de plazo */
#include <stdio.h>
#undef __USE_BSD  /* para que el read pueda ser interrumpido por una seal */
#include <signal.h>
#include <unistd.h>


volatile int flag;

/* funcin para atrapar la seal de alarma */
void ring()
  {
    flag=0;
  }

/* funcin que lee con timeout */
int gettext(char *buf, int bufsize, int timeout)
  {
    int nchars;

    signal(SIGALRM, ring);
    flag=1;
    (void)alarm(timeout);
    nchars = read(STDIN_FILENO, buf, bufsize);
    (void)alarm(0); /* para cancelar alarma pendiente */
    if(!flag)
        nchars=0;
    buf[nchars]='\0';
    return nchars;
  }

#define MAXLINEA 100
int main()
  {
    char linea[MAXLINEA+1];

    printf("Escriba su nombre: ");
    fflush(stdout);
    if(gettext(linea, MAXLINEA, 10)>0)
        printf("Gracias %s", linea);
    else
        printf("*** TIMEOUT ***\n");
  return 0;
  }

