#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>

void error(char *fmt, ...) {
  va_list args;

  va_start(args, fmt);
  fprintf(stderr, "Error: ");
  vfprintf(stderr, fmt, args);
  fprintf(stderr, "\n");
  va_end(args);

  exit(1);
}

int main(int argc, char *argv[]){
  int i, pid, fd[2];
  char receive[80];
 
  if ( pipe(fd) != 0) 
    error("No puedo crear pipe");
 
  i = 0;

  if((pid=fork())==-1)
    error("No puedo hacer fork");

  if (pid == 0) {           /* Hijo */
    close(fd[1]);           /* no usaremos pipe de escritura (fd=4) */
    i = read(fd[0], receive, 80);
    receive[i] = '\0';
    fprintf(stderr, "Mensaje Hijo: %s", receive);
    close(fd[0]);           /* cerramos pipe de lectura despues de 
                               usarlo fd=3 */
  } else {                  /* Padre */
    fprintf(stderr,
            "pipe file descriptors antes de dup: fd[0]->%d, fd[1]->%d \n", 
            fd[0], 
            fd[1]);
    close(fd[0]);           /* no usaremos pipe de lectura (fd=3) */
    close(1);               /* cerramos stdout fd=1 */
    i = dup(fd[1]);         /* duplicamos pipe de escritura, apuntandolo desde
                               stdout i.e. 1=4 */
    fprintf(stderr,
            "pipe file descriptors despues de dup: fd[0]->%d, fd[1]->%d \n", 
            fd[0], 
            i);
    close(fd[1]);           /* cerramos pipe de escritura despues de usarlo
                               fd=4 */
    if (execl("/bin/date","date",NULL) == -1) /* escribe en stdout, que en */
      error("No logr ejecutar date");        /* realidad es el pipe de    */
                                              /* escritura */
  }
  return 0;
} 
