/* Uso: my_cp from to */
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

void error(char *fmt, ...)
  {
    va_list args;

    va_start(args, fmt);
    fprintf(stderr, "Error: ");
    vfprintf(stderr, fmt, args);
    fprintf(stderr, "\n");
    va_end(args);

    exit(1);
  }

int main(int argc, char *argv[])
  {
    int f1, f2, n;
    char buf[BUFSIZ];

    if(argc!=3)
        error("Use: my_cp from to");

    if((f1=open(argv[1], O_RDONLY))==-1)
        error("Can't open %s", argv[1]);

    if((f2=creat(argv[2], 0600))==-1)
        error("Can't open %s", argv[2]);
    /* usando stats se pueden mantener los permisos */

    while((n=read(f1, buf, BUFSIZ))>0)
        if(write(f2, buf, n)!=n)
            error("Write error on file %s", argv[2]);

    return 0;
  }
