#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#define MAX_PATH 1000

void error(char *fmt, ...) {
  va_list args;
        
  va_start(args, fmt);
  fprintf(stderr, "Error: ");
  vfprintf(stderr, fmt, args);
  fprintf(stderr, "\n");
  va_end(args);
        
  exit(1);
}

void listdir(int indent, char *name) {
  DIR *current_dir;
  struct dirent *this_entry;
  char cwd[MAX_PATH+1];
  int i;
  struct stat status;

  /* imprimimos directorio actual */
  for(i=1; i<=indent; ++i)
    printf("    ");
  printf("%s\n", name);

  if(stat(name, &status)!=0)
    error("Can't stat %s", name);
  if(!S_ISDIR(status.st_mode))
    return;

  /* abrimos el directorio para lectura */
  if((current_dir=opendir(name))==NULL)
    error("Can't open directory %s", name);

  if(getcwd(cwd, MAX_PATH+1)==NULL)
    error("Can't get cwd");
  if(chdir(name)!=0)
    error("Can't chdir");

  while((this_entry=readdir(current_dir))!=NULL) {
    if(strcmp(this_entry->d_name, ".")==0 ||
       strcmp(this_entry->d_name, "..")==0)
       continue;

    listdir(indent+1, this_entry->d_name);
  }

  closedir(current_dir);
  chdir(cwd);
}

int main() {
  listdir(0, "..");
  return 0;
}

