#include <stdio.h>
#include <string.h>
 
#define ANCHO 1000
#define MAX 10000

void swap(void *v[], int i, int j) {
  void *aux;
        
  aux=v[i];
  v[i]=v[j];
  v[j]=aux;
}

/* compara numricamente */
int numcmp(char *s1, char *s2) {
  int i1, i2;

  i1=atoi(s1);
  i2=atoi(s2);

  return(i1<i2? -1 : i1==i2? 0 : 1);
}

void qsort(void *a[], int left, int right, int (*compare)(void *, void *)) {
  int i, last;
        
  if(left>=right)
    return;
        
  swap(a, left, (left+right)/2);
  last=left;
        
  /*
  +--+-----------+--------+--------------+
  |  |///////////|\\\\\\\\|              |
  +--+-----------+--------+--------------+
  left        last         i         right
  */
  
  for(i=left+1; i<=right; ++i)
    if((*compare)(a[i], a[left])<0)
      swap(a, ++last, i);
    swap(a, left, last);
        
  qsort(a, left, last-1, compare);
  qsort(a, last+1, right, compare);
}

 
main(int argc, char *argv[]) {
  char s[ANCHO];
  char *linea[MAX];
  int i, j, numeric=0;
  void qsort(void **, int, int, int (*)(void *, void *));

  numeric=(argc==2 && strcmp(argv[1], "-n")==0);
  if(argc>2|| argc==2 && !numeric){
    fprintf(stderr, "Use: ordena [-n]\n");
    exit(1);
  }
 
  for(i=0; fgets(s, ANCHO, stdin)!=NULL; ++i)
    linea[i]=strdup(s);
 
  qsort((void **)linea, 0, i-1, (numeric?(void *)numcmp:(void *)strcmp));

  for(j=0; j<i; ++j)
    fputs(linea[j], stdout);
}
