/*
Ejemplo implementacion algoritmo Verlet en 2D
para la ecuacion
ma=-(GmM/r^2) r^
Leer comentarios en ucursos, consultas
mcerda@dcc.uchile.cl
*/
class Tarea{

//constantes globales
static final double G=1.0;
static final double M=1.0;

/*
ALGORTIMO VERLET
----------------
Imprime en pantalla la orbitade una particula
es una elipse
*/
static public void main(String args[]){
	double x_actual, x_viejo, y_actual, y_viejo, aux_x, aux_y, F_x, F_y, dt;

	//este es el tau
	dt=0.001;
	/*
	Ahora se requieren 4 puntos para avanza en el tiempo
	Primero es la condicion inicial del usuario
	*/
	x_viejo=10.0; y_viejo=0.0;
	/*
	Esto es cuanto vale dt despues, hay varias soluciones les recomiendo hacer
	x_actual=x_viejo+dt*vx_inicial
	y_actual=y_viejo+dt*vy_inicial	
	*/
	x_actual=10.0; y_actual=0.0002;
	
	for(int i=0; i<1000000; i++){
		/*
		Primero guardo las coordenadas actuales
		*/
		aux_x=x_actual;
		aux_y=y_actual;
		
		/*
		Calculo la Fuerza y sus componentes
		*/
		F_x=-x_actual*G*M/Math.pow(x_actual*x_actual+y_actual*y_actual, 1.5);
		F_y=-y_actual*G*M/Math.pow(x_actual*x_actual+y_actual*y_actual, 1.5);
		/*
		Con esto itero, para avanzar en x y en y
		*/
		x_actual=2*aux_x -x_viejo +dt*dt*F_x;
		y_actual=2*aux_y -y_viejo +dt*dt*F_y;

		/*
		actualizo mi sistema de variables
		*/
		x_viejo=aux_x;
		y_viejo=aux_y;
		
		//imprimo en pantalla la posicion cada 1000 iteraciones
		if(i%1000==0)  
			System.out.println(x_actual+", "+y_actual);
	}
					
}

}