import extras.*;

class Bomba2{

    //////Parametros del sistema////////
    double re=Math.pow(10,4); //reynolds inicial
    double r=1;     //radio de la esfera
    double m=10;    //masa de la esfera

    //////Parametros de calculo
    /////tambien es importante variar el dt para ver como afecta eso el resultado    
    double tau=Math.pow(10,-4);    //delta de tiempo

    /////Parametros varios (en gral son constantes)
    //parametros iniciales
    double x=0.0;    //posicion en x
    double y=0.0;    //posicion en y
    double alfa=Math.PI/4; //angulo de salida (no se utiliza)
    
    double reX; //componente en x
    double reY; //componente en y

    double nu=0.000015; //viscocidad del medio
    double da=0.0001;     //delta angulo
    double gravedad=9.8;//gravedad
    double rho=1;   //densidad del medio
    double beta=tau*r*rho*nu/m; //agrupacion de parametros
    
    


    static public void main(String args[]){
        new Bomba2(args);
    }

    public Bomba2(String args[]){
        calcula();
    }
    public void calcula() {
        
        System.out.println("Calculo para Re= "+re);
        //calculo de angulo optimo con roce
        Conjunto conj=new Conjunto();
        for(int i=0; da*i < Math.PI/2; i++){
            
            x=0.0;    //posicion en x
            y=0.0;    //posicion en y
            reX=re*Math.cos(i*da); //componente en x
            reY=re*Math.sin(i*da); //componente en y
            
            while( y >= 0 ){
                reX=reX - (reX*6*Math.PI*beta + reX*beta*(Math.pow(reX*reX+reY*reY,0.5))/2);
                reY=reY - (reY*6*Math.PI*beta + reY*beta*(Math.pow(reX*reX+reY*reY,0.5))/2 ) -  beta*m*gravedad/(nu*nu*rho);
                    
                x=x + reX*tau*nu/r;
                y=y + reY*tau*nu/r;
            }
            
            conj.agregar(i*da, x);
        }
        double aux[]=conj.maximo();
        System.out.println("Alcance(con roce): "+ aux[1] + " para angulo (rad): "+aux[0]);
        
        //calculo de angulo optimo sin roce
        conj=new Conjunto();
        for(int i=0; da*i < Math.PI/2; i++){
            
            x=0.0;    //posicion en x
            y=0.0;    //posicion en y
            reX=re*Math.cos(i*da); //componente en x
            reY=re*Math.sin(i*da); //componente en y
            
            while( y >= 0 ){
                reX=reX;
                reY=reY - beta*m*gravedad/(nu*nu*rho);
                
                x=x + reX*tau*nu/r;
                y=y + reY*tau*nu/r;
            }
            
            conj.agregar(i*da, x);
        }
        aux=conj.maximo();
        System.out.println("Alcance(sin roce): "+ aux[1] + " para angulo (rad): "+aux[0]);
        
    
    }

}