public class ArregloEnteros extends Thread {
	protected int[] A;

	// Constructor
	public ArregloEnteros(int n) {
		A = new int[n];
	}

	// Mtodos Getter y Putter
	public void asignar(int n, int x) {
		A[n] = x;
	}
	public int ver(int n) {
		return A[n];
	}

	// Mtodo para ordenar
	public void ordenar() {
		// Se saca el nmero de procesos
		// necesarios. Es un entero
		int nProcesos = (int)Math.ceil(A.length / 50.0);
		
		

		// Se crea un arreglo que saca los
		// elementos que debe ordenar en
		// este proceso
		int[] Ac = new int[Math.min(50, A.length)];
		int n = 0;

		// Se llena el arreglo de este proceso
		for (int i=0; i<Ac.length; i++) {
			Ac[i] = A[n];
			n++;
		}

		// Se crean los nProcesos-1 procesos, ya que el
		// proceso principal puede ejecutar un
		// ordenamiento
		ArregloEnteros[] ae = null;
		if (nProcesos > 1) {
			int cant = A.length - 50;
			ae = new ArregloEnteros[nProcesos - 1];
			for (int i=0; i<ae.length; i++) {
				ae[i] = new ArregloEnteros(
					Math.min(50, cant));
				for (int j=0; j<ae[i].A.length; j++) {
					ae[i].asignar(j, A[n]);
					n++;
				}
				cant = cant - ae[i].A.length;
				ae[i].start();
			}
		}

		// Este es el que ordena el arreglo actual
		Ac = mergeSort(Ac, Ac.length);

		if (ae != null) {
			// Esperamos a que terminen todos los
			// procesos para que al final juntemos
			// todos los arreglos
			for (int i=0; i<ae.length; i++) {
				try {
					ae[i].join();
				}
				catch (InterruptedException e) {
				}
			}

			// Se crea un arreglo temporal para
			// guardar el primer arreglo ordenado
			int[] X = mergeSort(ae[ae.length-1].A, ae[ae.length-1].A.length);


			
			// Se toman los arreglos de a pares para
			// ir unindolos (merge)
			for (int i=ae.length-2; i>=0; i--) {
				X = merge(X, ae[i].A);
			}

			// Se une ahora con el arreglo local
			X = merge(X, Ac);

			// Se vuelve al arreglo original el
			// combinado
			for (int i=0; i<X.length; i++) {
				A[i] = X[i];
			}
		}
		else {
			// Se vuelve al arreglo original el
			// arreglo local (menos que 50)
			for (int i=0; i<Ac.length; i++) {
				A[i] = Ac[i];
			}
		}
	}

	// Mtodo que hace el mezclado de dos arreglos
	private int[] merge(int[] A, int[] B) {
		int i = 0;
		int j = 0;
		int[] X = new int[A.length + B.length];
		int k = 0;
		while (i < A.length || j < B.length) {
			if (i < A.length && j < B.length) {
				if (A[i] < B[j]) {
					X[k] = A[i];
					i++;
				}
				else {
					X[k] = B[j];
					j++;
				}
			}
			else if (i >= A.length) {
				X[k] = B[j];
				j++;
			}
			else if (j >= B.length) {
				X[k] = A[i];
				i++;
			}
			k++;
		}
		return X;
	}

	// Mtodo recursivo que hacer el MergeSort
	private int[] mergeSort(int[] A, int n) {
		if (n == 1) return A;
		int i = n/2;
		int[] A1 = new int[i];
		int[] A2 = new int[n-i];
		for (int j=0; j<i; j++) {
			A1[j] = A[j];
		}
		A1 = mergeSort(A1, i);
		for (int j=n; j>i; j--) {
			A2[n-j] = A[j-1];
		}
		A2 = mergeSort(A2, n-i);
		int[] X = merge(A1, A2);
		return X;
	}

	public void run() {
		A = mergeSort(A, A.length);
	}

	static public void main(String[] args) {
		ArregloEnteros ae = new ArregloEnteros(110);
		for (int i=0; i<ae.A.length; i++) {
			ae.asignar(i, (int) Math.round(Math.random() * 100) + 1);
		}
		ae.ordenar();
		for (int i=0; i<ae.A.length; i++) {
			System.out.print("(" + i + ") = " + ae.ver(i) + " / ");
		}
		System.out.println();
	}
}

