import java.awt.*;
import java.awt.event.*;

public class Timer extends Frame implements ActionListener, WindowListener {
	public Canvas timer;
	public Button start, stop;
	public Tic counter;
	public boolean running;

	public Timer() {
		this.setLayout(new BorderLayout());
		this.addWindowListener(this);
		this.setBackground(Color.BLACK);

		this.add("East", new Label(" "));
		this.add("West", new Label(" "));

		timer = new Canvas();
		timer.setSize(200, 40);
		timer.setBackground(Color.BLACK);
		this.add("Center", timer);

		Panel p = new Panel();
		p.setLayout(new FlowLayout());

		start = new Button("Iniciar");
		start.setBackground(Color.BLACK);
		start.setForeground(Color.GREEN);
		start.setEnabled(true);
		start.addActionListener(this);
		p.add(start);

		stop = new Button("Detener");
		stop.setBackground(Color.BLACK);
		stop.setForeground(Color.GREEN);
		stop.setEnabled(false);
		stop.addActionListener(this);
		p.add(stop);

		this.add("South", p);

		this.pack();
		this.show();

		setTimer(0);
		running = false;
	}

	public void setTimer(long t) {
		long mm, ss, cc;
		mm = t / 60000;
		ss = (t - mm * 60000) / 1000;
		cc = (t - ss * 1000 - mm * 60000) / 10;
		String lab = "";
		if (mm < 10) lab += "0";
		lab += mm + ":";
		if (ss < 10) lab += "0";
		lab += ss + ":";
		if (cc < 10) lab += "0";
		lab += cc;
		Graphics g = timer.getGraphics();
		g.setColor(Color.GREEN);
		g.setFont(new Font("Courier", Font.BOLD, 42));
		g.clearRect(0, 0, 200, 40);
		g.drawString(lab, 0, 35);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == start) {
			counter = new Tic(1000);
			running = true;
			counter.start();
			start.setEnabled(false);
			stop.setEnabled(true);
		}
		else if (e.getSource() == stop) {
			running = false;
			counter = null;
			start.setEnabled(true);
			stop.setEnabled(false);
		}
	}

	public void windowClosing(WindowEvent e) {
		System.exit(0);
	}

	public void windowClosed(WindowEvent e) { }
	public void windowOpened(WindowEvent e) { }
	public void windowIconified(WindowEvent e) { }
	public void windowDeiconified(WindowEvent e) { }
	public void windowActivated(WindowEvent e) { }
	public void windowDeactivated(WindowEvent e) { }

	class Tic extends Thread {
		long delta;
		public Tic(long d) {
			delta = d;
		}

		public void run() {
			long t=0;
			while (running) {
				setTimer(t);
				try {
					sleep(delta);
				}
				catch (InterruptedException e) {
					break;
				}
				t += delta;
			}
		}
	}

	public static void main(String[] args) {
		Timer t = new Timer();
	}
}