import java.awt.*;
import java.awt.event.*;

public class Graficador {
	// Se declaran las componente
	public Frame fr_ventana;
	public CanvasGraficador cv_lienzo;
	public TextField tf_distancia, tf_longitud, tf_intensidad;
	public Button bt_graficar, bt_salir;

	// Se guarda la funcin que se quiere graficar
	public Funcion f = null;

	public Graficador() {
		// Se crea la ventana
		fr_ventana = new Frame("Graficador ACME");
		fr_ventana.setLayout(new BorderLayout());
		fr_ventana.setBackground(Color.gray);

		// Se crea el lienzo de dibujo
		cv_lienzo = new CanvasGraficador();
		cv_lienzo.setSize(800, 600);
		cv_lienzo.setBackground(Color.white);
		fr_ventana.add("Center", cv_lienzo);

		// Se crea el panel de opciones inferior
		Panel pn_botonera = new Panel();
		pn_botonera.setLayout(new FlowLayout());
		tf_distancia = new TextField("0", 2);
		pn_botonera.add(tf_distancia);
		tf_intensidad = new TextField("1", 2);
		pn_botonera.add(tf_intensidad);
		tf_longitud = new TextField("1", 2);
		pn_botonera.add(tf_longitud);
		bt_graficar = new Button(" > Graficar < ");
		pn_botonera.add(bt_graficar);
		bt_salir = new Button(" > Salir < ");
		pn_botonera.add(bt_salir);
		fr_ventana.add("South", pn_botonera);

		// Se agregan los eventos en las componente
		bt_graficar.addActionListener(new ButtonListener());
		bt_salir.addActionListener(new ButtonListener());

		// Se muestra la ventana con todas las componente
		fr_ventana.pack();
		fr_ventana.show();
	}

	// Opciones de accin cuando se presiona un botn
	class ButtonListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			if (e.getSource() == bt_salir) {
				// Se ejecuta cuando se presiona SALIR
				System.exit(0);
			}

			// Solo se grafica cuando hay funcin almacenada
			f = new Seno(Double.parseDouble(tf_distancia.getText()), Double.parseDouble(tf_intensidad.getText()), Double.parseDouble(tf_longitud.getText()));
			int x0 = -1;
			for (int x=0; x<cv_lienzo.getWidth(); x++) {
				if (x0 >= 0) {
					cv_lienzo.unirPuntos(x0, (int) Math.round(f.eval(x0)), x, (int) Math.round(f.eval(x)), Color.red);
				}
				x0 = x;
			}
		}
	}

	public static void main (String[] args) {
		Graficador g = new Graficador();
	}
}