// Paquetes de clases para hacer interfaces grficas
import java.awt.*;
import java.awt.event.*;

// Paquetes adicionales
import java.io.*;

public class FichaPersonalFrame {
	// Se declaran las variables que representan los objetos grficos
	public Frame 		fr_ventana;
	public TextField 	tf_nombre,
	                 	tf_cumpledia,
	                 	tf_cumplemes,
	                 	tf_email;
	public Choice 		ch_pais;
	public List 		ls_hobbies;
	public TextArea 	ta_saludo;
	public Button		bt_guardar,
						bt_borrar;

	// Se declara el constructor. En l se crea la interfaz grfica
	public FichaPersonalFrame() {
		// Se crea el objeto que representa la ventana y se le da
		// un layout principal
		fr_ventana = new Frame("Ficha Personal");
		fr_ventana.setLayout(new BorderLayout());

		// Se crea una componente para el ttulo y se pone arriba
		Label lb_titulo = new Label("Ficha Personal", Label.CENTER);
		fr_ventana.add("North", lb_titulo);

		// Se crea el panel interior que contendr la info de la ficha
		Panel pn_ficha = new Panel();
		pn_ficha.setLayout(new GridLayout(6, 2));

		// Se crean las componentes para el nombre y se ubican
		Label lb_nombre = new Label("Nombre :", Label.RIGHT);
		pn_ficha.add(lb_nombre);
		Panel pn_nombre = new Panel();
		pn_nombre.setLayout(new FlowLayout(0));
		tf_nombre = new TextField(30);
		pn_nombre.add(tf_nombre);
		pn_ficha.add(pn_nombre);

		// Se crean las componentes para el cumpleaos y se ubican
		Label lb_cumple = new Label("Cumpleaos :", Label.RIGHT);
		pn_ficha.add(lb_cumple);
		Panel pn_cumple = new Panel();
		pn_cumple.setLayout(new FlowLayout(0));
		tf_cumpledia = new TextField(2);
		pn_cumple.add(tf_cumpledia);
		pn_cumple.add(new Label("/"));
		tf_cumplemes = new TextField(2);
		pn_cumple.add(tf_cumplemes);
		pn_ficha.add(pn_cumple);

		// Se crean las componentes para el email y se ubican
		Label lb_email = new Label("Correo Electrnico :", Label.RIGHT);
		pn_ficha.add(lb_email);
		Panel pn_email = new Panel();
		pn_email.setLayout(new FlowLayout(0));
		tf_email = new TextField(15);
		pn_email.add(tf_email);
		pn_ficha.add(pn_email);

		// Se crean las componentes para el email y se ubican
		Label lb_pais = new Label("Pas de Procedencia :", Label.RIGHT);
		pn_ficha.add(lb_pais);
		Panel pn_pais = new Panel();
		pn_pais.setLayout(new FlowLayout(0));
		ch_pais = new Choice();
		ch_pais.add("Chile");
		ch_pais.add("Argentina");
		ch_pais.add("Brasil");
		ch_pais.add("Otro");
		pn_pais.add(ch_pais);
		pn_ficha.add(pn_pais);

		// Se crean las componentes para los hobbies y se ubican
		Label lb_hobbies = new Label("Hobbies :", Label.RIGHT);
		pn_ficha.add(lb_hobbies);
		Panel pn_hobbies = new Panel();
		pn_hobbies.setLayout(new FlowLayout(0));
		ls_hobbies = new List(1, true);
		ls_hobbies.add("Leer");
		ls_hobbies.add("Escuchar Msica");
		ls_hobbies.add("Salir al Cine");
		ls_hobbies.add("Otro");
		pn_hobbies.add(ls_hobbies);
		pn_ficha.add(pn_hobbies);

		// Se crean las componentes para el saludo y se ubican
		Label lb_saludo = new Label("Saludo :", Label.RIGHT);
		pn_ficha.add(lb_saludo);
		Panel pn_saludo = new Panel();
		pn_saludo.setLayout(new FlowLayout(0));
		ta_saludo = new TextArea("", 1, 20, TextArea.SCROLLBARS_VERTICAL_ONLY);
		pn_saludo.add(ta_saludo);
		pn_ficha.add(pn_saludo);

		// Se agrega el panel interior a la ventana
		fr_ventana.add(pn_ficha);

		// Se crean las componentes para el saludo y se ubican
		Panel pn_accion = new Panel();
		pn_accion.setLayout(new FlowLayout());
		bt_guardar = new Button("Guardar");
		pn_accion.add(bt_guardar);
		bt_borrar = new Button("Borrar");
		pn_accion.add(bt_borrar);
		fr_ventana.add("South", pn_accion);

		// Se agregan los eventos en los botones
		bt_guardar.addActionListener(new BotoneraListener());
		bt_borrar.addActionListener(new BotoneraListener());

		// Se agregan los eventos a la ventana
		fr_ventana.addWindowListener(new VentanaListener());

		// Se empaqueta y se muestra la ventana construda
		fr_ventana.pack();
		fr_ventana.show();
	}

	// Definicin de los eventos:
	// Eventos de los botones
	class BotoneraListener implements ActionListener {
		// Mtodo que se ejecuta cuando se hace clic en botn
		public void actionPerformed(ActionEvent e) {
			// Verificamos si el botn es el de guardar
			if (e.getSource() == bt_guardar) {
				try {
					PrintWriter pw = new PrintWriter(new FileWriter(tf_nombre.getText() + ".txt"));
					pw.println("Nombre: " + tf_nombre.getText());
					pw.println("Cumpleaos: " + tf_cumpledia.getText() + "/" + tf_cumplemes.getText());
					pw.println("e-mail: " + tf_email.getText());
					pw.println("Pas de Procedencia: " + ch_pais.getSelectedItem());
					pw.print("Hobbies: ");
					int[] hobbies = ls_hobbies.getSelectedIndexes();
					for (int i=0; i<hobbies.length; i++)
						pw.print(ls_hobbies.getItem(i) + " ");
					pw.println("");
					pw.println("Saludo: " + ta_saludo.getText());
					pw.close();
				}
				catch (Exception x) {
					x.printStackTrace();
				}
			}
			// Verificamos si el botn es el de borrar
			else if (e.getSource() == bt_borrar) {
				tf_nombre.setText("");
				tf_cumpledia.setText("");
				tf_cumplemes.setText("");
				tf_email.setText("");
				ta_saludo.setText("");
			}
		}
	}

	// Eventos de la ventana
	class VentanaListener implements WindowListener {
		// Mtodo del evento de apertura de ventana
		public void windowOpen(WindowEvent e) { }

		// Mtodo del evento de ventana abierta
		public void windowOpened(WindowEvent e) { }

		// Mtodo del evento de cerrado de ventana
		public void windowClosing(WindowEvent e) {
			System.exit(0);
		}

		// Mtodo del evento de ventana cerrada
		public void windowClosed(WindowEvent e) { }

		// Mtodo del evento de ventana iconificada
		public void windowIconified(WindowEvent e) { }

		// Mtodo del evento de ventana desiconificada
		public void windowDeiconified(WindowEvent e) { }

		// Mtodo del evento de ventana activa
		public void windowActivated(WindowEvent e) { }

		// Mtodo del evento de ventana desactiva
		public void windowDeactivated(WindowEvent e) { }
	}

	// El programa principal para ejecutar la interfaz
	static public void main(String[] args) {
		FichaPersonalFrame fpf = new FichaPersonalFrame();
	}
}
