import java.awt.*;
import java.util.Vector;

class MiCanvas extends Canvas {

	Laboratorio lab;

	MiCanvas(Laboratorio l) {
		lab = l;
	}

	public void paint(Graphics g) {
		lab.dibuja(g);
	}

	public Dimension getPreferredSize() {
		return new Dimension(800, 600);
	}
}

public class Laboratorio extends Thread {

	Vector masas;
	Vector resortes;

	public Laboratorio() {
		masas = new Vector();
		resortes = new Vector();
	}

	public void dibuja(Graphics g) {
		g.setColor(Color.black);
		for (int i = 0; i < masas.size(); i++) {
			Masa m = (Masa) masas.get(i);
			g.fillOval((int) m.x - 3, (int) m.y - 3, 6, 6);
		}
		for (int i = 0; i < resortes.size(); i++) {
			Resorte r = (Resorte) resortes.get(i);
			if (r.fuerza>0)
	                        g.setColor(new Color(Math.min(255, Math.abs((int) r.fuerza)), 0, 0));
			else
	                        g.setColor(new Color(0,0,Math.min(255, Math.abs((int) r.fuerza))));
			g.drawLine((int) r.m1.x, (int) r.m1.y, (int) r.m2.x, (int) r.m2.y);
		}
	}

	void add(Masa m) {
		masas.add(m);
	}

	void add(Resorte r) {
		resortes.add(r);
	}

	void calculaNuevaPosicion() {
		for (int i = 0; i < masas.size(); i++) {
			Masa m = (Masa) masas.get(i);
			m.fx = 0;
			m.fy = 0;
		}
		for (int i = resortes.size()-1;i>=0; i--) {
			Resorte r = (Resorte) resortes.get(i);
			r.setFuerza();
			if (r.fuerza>220)
				resortes.remove(i);
		}

		for (int i = 0; i < masas.size(); i++) {
			Masa m = (Masa) masas.get(i);
			m.integra();
		}
	}

	public static void main(String args[]) {
		new Laboratorio().start();
	}

	public void run() {
		Laboratorio lab = new Laboratorio();
		Masa m[] = new Masa[20];
		for (int i = 0; i < 20; i++) {
			m[i] = new Masa(5, 10 + (i % 10) * 30, 100 + (i / 10) * 30);
			lab.add(m[i]);
		}
		for (int i = 0; i < 9; i++) {
			Masa m1 = m[i];
			Masa m2 = m[i + 1];
			Masa m4 = m[i + 10];
			Masa m3 = m[i + 11];
			lab.add(new Resorte(m1, m2, 255));
			lab.add(new Resorte(m2, m3, 255));
			lab.add(new Resorte(m3, m4, 255));
			lab.add(new Resorte(m3, m1, 255));
			lab.add(new Resorte(m2, m4, 255));
		}
		Masa mas=new Masa(5,0,0);
		m[0].setFijo();
		m[10].setFijo();
		lab.add(new Resorte(mas,m[9],255));

		Frame f = new Frame();
		MiCanvas mic = new MiCanvas(lab);
		f.add(mic);
		f.pack();
		f.show();
		while (true) {
			try {
				sleep(20);
			} catch (Exception e) {
			}
			lab.calculaNuevaPosicion();
			mic.repaint();
		}
	}
}
