
import java.awt.*;

import java.awt.event.*;

import java.applet.*;


public class Dibujador implements ActionListener {


	// componentes graficos
	Canvas canvas;
	Button dibujar;
	Button salir;
	Choice opciones;
	TextField x;
	TextField y;
	Label figura;
	Label tituloX;
	Label tituloY;

	public Dibujador() {

		// inicializar variables


		// boton
		dibujar = new Button("Dibujar");
		dibujar.addActionListener(this);
		salir = new Button("Salir");
		salir.addActionListener(this);

		// canvas
		canvas = new Canvas();
		canvas.setSize(400, 300);

		// opciones (combo box)
		opciones = new Choice();
		opciones.add("-- Seleccione --");
		opciones.add("Cuadrado");
		opciones.add("Rectangulo");
		opciones.add("Circulo");
		opciones.add("Ovalo");
		opciones.add("Tringulo");

		// label
		figura = new Label("Figura: ");
		tituloX = new Label("x: ");
		tituloY = new Label("y: ");

		// textfield
		x = new TextField(5);
		y = new TextField(5);

		// diagramar frame
		Panel p = new Panel();
		p.setLayout(new GridLayout(4, 2));

		// agregar componentes al panel
		p.add(figura);
		p.add(opciones);
		p.add(tituloX);
		p.add(x);
		p.add(tituloY);
		p.add(y);
		p.add(dibujar);
		p.add(salir);

	// fijar layout general
		Frame f=new Frame();
		f.setLayout(new BorderLayout());
		f.add(new Label("Dibujar Figuras"),BorderLayout.NORTH);
		f.add(p,BorderLayout.CENTER);
		f.add(canvas,BorderLayout.SOUTH);
		f.show();

	}

	public void actionPerformed(ActionEvent e) {

		// si se apreto boton salir
		if (e.getSource() == salir) {
			System.exit(0);
		}
		// si se apreto boton dibujar
		else if (e.getSource() == dibujar) {

			// obtener objeto graphic del canvas
			Graphics graphics = canvas.getGraphics();

			// obtener coordenadas 
			int valorX = Integer.parseInt(x.getText());
			int valorY = Integer.parseInt(y.getText());

			// obtener figura a dibujar
			int eleccion = opciones.getSelectedIndex();

			if (eleccion==1) {
				graphics.setColor(Color.blue);
				graphics.drawRect(valorX, valorY, 40, 40);
			}
			if (eleccion==1) {
				graphics.setColor(Color.red);
				graphics.drawRect(valorX, valorY, 40, 60);
			}
			if (eleccion==1) {
				graphics.setColor(Color.green);
				graphics.drawOval(valorX, valorY, 80, 80);
			}
			if (eleccion==1) {
				graphics.setColor(Color.yellow);
				graphics.drawOval(valorX, valorY, 150, 40);
			}
			if (eleccion==1) {
				graphics.setColor(Color.magenta);
				graphics.drawLine(valorX, valorY, valorX+50, valorY);
				graphics.drawLine(valorX+50, valorY, valorX+25, valorY-35);
				graphics.drawLine(valorX+25, valorY-35, valorX, valorY);
			}
		}

	}

	public static void main(String[] args) {
		new Dibujador();
	}

}
